/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;
import steve_gall.minecolonies_compatibility.module.common.OptionalModule;
import steve_gall.minecolonies_compatibility.module.common.ae2.AppliedEnergistics2Module;
import steve_gall.minecolonies_compatibility.module.common.aether.AetherModule;
import steve_gall.minecolonies_compatibility.module.common.ars_nouveau.ArsNouveauModule;
import steve_gall.minecolonies_compatibility.module.common.atmospheric.AtmosphericModule;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.ButchercraftModule;
import steve_gall.minecolonies_compatibility.module.common.cobblemon.CobblemonModule;
import steve_gall.minecolonies_compatibility.module.common.croptopia.CroptopiaModule;
import steve_gall.minecolonies_compatibility.module.common.culturaldelights.CulturalDelightsModule;
import steve_gall.minecolonies_compatibility.module.common.ewewukeks_musketmod.ewewukekMusketModule;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.FarmersDelightModule;
import steve_gall.minecolonies_compatibility.module.common.fruitsdelight.FruitsDelightModule;
import steve_gall.minecolonies_compatibility.module.common.ie.IEModule;
import steve_gall.minecolonies_compatibility.module.common.jade.JadeModule;
import steve_gall.minecolonies_compatibility.module.common.lets_do_meadow.LetsDoMeadowModule;
import steve_gall.minecolonies_compatibility.module.common.minecraft.MinecraftModule;
import steve_gall.minecolonies_compatibility.module.common.neapolitan.NeapolitanModule;
import steve_gall.minecolonies_compatibility.module.common.oreberries.OreberriesModule;
import steve_gall.minecolonies_compatibility.module.common.pamhc2trees.PamsHarvestCraft2TreesModule;
import steve_gall.minecolonies_compatibility.module.common.polymorph.PolymorphModule;
import steve_gall.minecolonies_compatibility.module.common.regions_unexplored.RegionsUnexploredModule;
import steve_gall.minecolonies_compatibility.module.common.reliquary.ReliquaryModule;
import steve_gall.minecolonies_compatibility.module.common.undergarden.UndergardenModule;

public class ModuleManager {
    private static final List<OptionalModule<?>> _MODULES = new ArrayList();
    public static final List<OptionalModule<?>> MODULES = Collections.unmodifiableList(_MODULES);
    private static boolean INITIALIZED;
    private static final List<OptionalModule<?>> _LOADED_MODULES;
    public static final List<OptionalModule<?>> LOADED_MODULES;
    public static final OptionalModule<MinecraftModule> MINECRAFT;
    public static final OptionalModule<AppliedEnergistics2Module> AE2;
    public static final OptionalModule<AetherModule> AETHER;
    public static final OptionalModule<ArsNouveauModule> ARS_NOUVEAU;
    public static final OptionalModule<AtmosphericModule> ATMOSPHERIC;
    public static final OptionalModule<CobblemonModule> COBBLEMON;
    public static final OptionalModule<CroptopiaModule> CROPTOPIA;
    public static final OptionalModule<CulturalDelightsModule> CULTURALDELIGHTS;
    public static final OptionalModule<ewewukekMusketModule> EWEWUKEK_MUSKET;
    public static final OptionalModule<FarmersDelightModule> FARMERSDELIGHT;
    public static final OptionalModule<ButchercraftModule> BUTCHERCRAFT;
    public static final OptionalModule<FruitsDelightModule> FRUITSDELIGHT;
    public static final OptionalModule<IEModule> IE;
    public static final OptionalModule<JadeModule> JADE;
    public static final OptionalModule<LetsDoMeadowModule> LETS_DO_MEADOW;
    public static final OptionalModule<NeapolitanModule> NEAPOLITAN;
    public static final OptionalModule<OreberriesModule> OREBERRIES;
    public static final OptionalModule<PamsHarvestCraft2TreesModule> PHC2TREES;
    public static final OptionalModule<PolymorphModule> POLYMORPH;
    public static final OptionalModule<RegionsUnexploredModule> REGIONS_UNEXPLORED;
    public static final OptionalModule<ReliquaryModule> RELIQUARY;
    public static final OptionalModule<UndergardenModule> UNDERGARDEN;

    private static <MODULE extends AbstractModule> OptionalModule<MODULE> register(String modid, Supplier<Supplier<MODULE>> initializer) {
        return ModuleManager.register(modid, OptionalModule::new, initializer);
    }

    private static <WRAPPER extends OptionalModule<MODULE>, MODULE extends AbstractModule> WRAPPER register(String modid, BiFunction<String, Supplier<Supplier<MODULE>>, WRAPPER> wrapper, Supplier<Supplier<MODULE>> initializer) {
        OptionalModule module = (OptionalModule)wrapper.apply(modid, initializer);
        _MODULES.add(module);
        return (WRAPPER)module;
    }

    public static boolean isInitialized() {
        return INITIALIZED;
    }

    public static void initialize() {
        if (INITIALIZED) {
            throw new IllegalCallerException();
        }
        INITIALIZED = true;
        _LOADED_MODULES.clear();
        for (OptionalModule<?> module : MODULES) {
            module.tryLoad();
            if (!module.isLoaded()) continue;
            _LOADED_MODULES.add(module);
        }
    }

    static {
        _LOADED_MODULES = new ArrayList();
        LOADED_MODULES = Collections.unmodifiableList(_LOADED_MODULES);
        MINECRAFT = ModuleManager.register("minecraft", () -> MinecraftModule::new);
        AE2 = ModuleManager.register("ae2", () -> AppliedEnergistics2Module::new);
        AETHER = ModuleManager.register("aether", () -> AetherModule::new);
        ARS_NOUVEAU = ModuleManager.register("ars_nouveau", () -> ArsNouveauModule::new);
        ATMOSPHERIC = ModuleManager.register("atmospheric", () -> AtmosphericModule::new);
        COBBLEMON = ModuleManager.register("cobblemon", () -> CobblemonModule::new);
        CROPTOPIA = ModuleManager.register("croptopia", () -> CroptopiaModule::new);
        CULTURALDELIGHTS = ModuleManager.register("culturaldelights", () -> CulturalDelightsModule::new);
        EWEWUKEK_MUSKET = ModuleManager.register("musketmod", () -> ewewukekMusketModule::new);
        FARMERSDELIGHT = ModuleManager.register("farmersdelight", () -> FarmersDelightModule::new);
        BUTCHERCRAFT = ModuleManager.register("butchercraft", () -> ButchercraftModule::new);
        FRUITSDELIGHT = ModuleManager.register("fruitsdelight", () -> FruitsDelightModule::new);
        IE = ModuleManager.register("immersiveengineering", () -> IEModule::new);
        JADE = ModuleManager.register("jade", () -> JadeModule::new);
        LETS_DO_MEADOW = ModuleManager.register("meadow", () -> LetsDoMeadowModule::new);
        NEAPOLITAN = ModuleManager.register("neapolitan", () -> NeapolitanModule::new);
        OREBERRIES = ModuleManager.register("oreberriesreplanted", () -> OreberriesModule::new);
        PHC2TREES = ModuleManager.register("pamhc2trees", () -> PamsHarvestCraft2TreesModule::new);
        POLYMORPH = ModuleManager.register("polymorph", () -> PolymorphModule::new);
        REGIONS_UNEXPLORED = ModuleManager.register("regions_unexplored", () -> RegionsUnexploredModule::new);
        RELIQUARY = ModuleManager.register("reliquary", () -> ReliquaryModule::new);
        UNDERGARDEN = ModuleManager.register("undergarden", () -> UndergardenModule::new);
    }
}

