/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.client.butchercraft;

import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import steve_gall.minecolonies_compatibility.core.client.gui.TeachCraftingRecipeScreen;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.crafting.GrinderRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.init.ModuleCraftingTypes;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.menu.GrinderTeachMenu;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class GrinderTeachScreen
extends TeachCraftingRecipeScreen<GrinderTeachMenu, RecipeHolder<GrinderRecipe>> {
    public static final ResourceLocation TEXTURE = MineColoniesCompatibility.rl("textures/gui/butchercraft_grinder_teach.png");

    public GrinderTeachScreen(GrinderTeachMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public CraftingType getCraftingType() {
        return (CraftingType)ModuleCraftingTypes.GRINDER.get();
    }

    @Override
    protected ICustomizedRecipeStorage createRecipeStorage(RecipeHolder<GrinderRecipe> recipe, List<ItemStorage> input) {
        ItemStorage ingredient = input.get(0);
        ingredient.setAmount(((GrinderRecipe)recipe.value()).count());
        ItemStorage attachment = input.get(1);
        ItemStorage casing = input.get(2);
        Container resultContainer = ((GrinderTeachMenu)this.menu).getResultContainer();
        ItemStack output = resultContainer.getItem(0);
        return new GrinderRecipeStorage(recipe.id(), ItemStorageHelper.filterNotEmpty(Arrays.asList(ingredient, casing)), attachment, output);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.hoveredSlot != null) {
            if (((GrinderTeachMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot.hasItem()) {
                ItemStack itemstack = this.hoveredSlot.getItem();
                graphics.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, mouseX, mouseY);
            } else if (this.hoveredSlot.container == ((GrinderTeachMenu)this.menu).getInputContainer()) {
                int slotIndex = this.hoveredSlot.getSlotIndex();
                List<Object> tooltip = Collections.emptyList();
                String prefix = MineColoniesCompatibility.tl("text.butchercraft_grinder.");
                if (slotIndex == 0) {
                    tooltip = Arrays.asList(Component.translatable((String)(prefix + "ingredient")));
                } else if (slotIndex == 1) {
                    tooltip = Arrays.asList(Component.translatable((String)(prefix + "attachment")));
                } else if (slotIndex == 2) {
                    tooltip = Arrays.asList(Component.translatable((String)(prefix + "casing")));
                }
                if (tooltip.size() > 0) {
                    graphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
                }
            }
        }
    }
}

