/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.colony.jobs.JobFarmer;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.entity.ai.workers.production.agriculture.EntityAIWorkFarmer;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantSeedContext;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.block.BlockUtils;

@Mixin(value={EntityAIWorkFarmer.class}, remap=false)
public abstract class EntityAIWorkFarmerMixin
extends AbstractEntityAICrafting<JobFarmer, BuildingFarmer> {
    public EntityAIWorkFarmerMixin(@NotNull JobFarmer job) {
        super((AbstractJobCrafter)job);
    }

    @Shadow(remap=false)
    private void equipHoe() {
    }

    @Inject(method={"plantCrop"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void plantCrop(ItemStack stack, @NotNull BlockPos position, CallbackInfoReturnable<Boolean> cir) {
        if (stack == null || stack.isEmpty()) {
            cir.setReturnValue((Object)false);
            return;
        }
        AbstractEntityCitizen worker = this.worker;
        int slot = worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(stack.getItem());
        if (slot == -1) {
            cir.setReturnValue((Object)false);
            return;
        }
        ServerLevel level = this.world;
        BlockPos plantPosition = position.above();
        if (!level.getBlockState(plantPosition).isAir()) {
            cir.setReturnValue((Object)true);
            return;
        }
        PlantSeedContext context = new PlantSeedContext((LevelReader)level, plantPosition, stack);
        CustomizedCrop crop = CustomizedCrop.selectBySeed(context);
        BlockState plantState = null;
        if (crop != null) {
            plantState = crop.getPlantState(context);
            if (plantState == null) {
                cir.setReturnValue((Object)true);
                return;
            }
        } else {
            BlockItem item;
            Item item2 = stack.getItem();
            if (item2 instanceof BlockItem && (item2 = (item = (BlockItem)item2).getBlock()) instanceof StemBlock) {
                StemBlock block = (StemBlock)item2;
                BlockPos prevPos = ((BuildingFarmer)this.building).getPrevPos();
                if (prevPos != null && !level.isEmptyBlock(prevPos.above())) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                plantState = block.defaultBlockState();
            }
        }
        if (plantState != null) {
            level.setBlock(plantPosition, plantState, 3);
            worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"findHarvestableSurface"}, remap=false, at={@At(value="RETURN")}, cancellable=true)
    private void findHarvestableSurface(@NotNull BlockPos position, CallbackInfoReturnable<BlockPos> cir) {
        BlockState state;
        if (position == null) {
            return;
        }
        ServerLevel level = this.world;
        BlockPos plantPosition = position.above();
        PlantBlockContext context = new PlantBlockContext((LevelReader)level, plantPosition, state = level.getBlockState(plantPosition));
        CustomizedCrop crop = CustomizedCrop.selectByCrop(context);
        if (crop != null) {
            CustomizedCrop.SpecialHarvestPositionFunction specialPositionFunction = crop.getSpecialHarvestPosition(context);
            if (specialPositionFunction != null) {
                BlockPos harvestPosition = specialPositionFunction.apply(context);
                if (harvestPosition != null) {
                    cir.setReturnValue((Object)harvestPosition.below());
                } else {
                    cir.setReturnValue(null);
                }
            }
        } else if (MineColoniesCompatibility.COMPAT.getStem(state.getBlock()) != null) {
            cir.setReturnValue((Object)position);
        }
    }

    @WrapOperation(method={"harvestIfAble"}, remap=false, at={@At(value="INVOKE", target="mineBlock(Lnet/minecraft/core/BlockPos;)Z")})
    private boolean harvestIfAble_mineBlock(EntityAIWorkFarmer self, BlockPos position, Operation<Boolean> operation) {
        CustomizedCrop.SpecialHarvestMethodFunction method;
        AbstractEntityCitizen worker = this.worker;
        ServerLevel level = this.world;
        BlockState state = level.getBlockState(position);
        PlantBlockContext context = new PlantBlockContext((LevelReader)level, position, state);
        CustomizedCrop crop = CustomizedCrop.selectByCrop(context);
        if (crop != null && (method = crop.getSpecialHarvestMethod(context)) != null) {
            if (!this.holdEfficientTool(state, position)) {
                return false;
            }
            if (this.hasNotDelayed(this.getBlockMiningTime(state, position))) {
                return false;
            }
            InventoryCitizen inventory = worker.getInventoryCitizen();
            InteractionHand hand = worker.getUsedItemHand();
            HarvesterContext harvester = new HarvesterContext((LivingEntity)worker, inventory.getHeldItem(hand));
            List drops = this.increaseBlockDrops(method.harvest(context, harvester));
            level.playSound(null, position, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            for (ItemStack stack : drops) {
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((ItemStack)stack, (IItemHandler)inventory);
            }
            worker.swing(hand);
            CitizenItemUtils.damageItemInHand((AbstractEntityCitizen)worker, (InteractionHand)hand, (int)1);
            this.incrementActionsDone();
            worker.decreaseSaturationForContinuousAction();
            this.onBlockDropReception(drops);
            return true;
        }
        return (Boolean)operation.call(new Object[]{self, position});
    }

    @WrapOperation(method={"createCorrectFarmlandForSeed"}, remap=false, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", remap=true)})
    private boolean createCorrectFarmlandForSeed_setBlockAndUpdate(ServerLevel level, BlockPos pos, BlockState next, Operation<Boolean> operation) {
        ItemStack hoe;
        InteractionHand hand;
        IColony colony;
        BlockState tilled;
        if (next.getBlock() == Blocks.FARMLAND && (tilled = BlockUtils.getHoeTilledState(colony = this.worker.getCitizenData().getColony(), (Level)level, pos, hand = this.worker.getUsedItemHand(), hoe = this.worker.getInventoryCitizen().getHeldItem(hand), false)) != null) {
            next = tilled;
        }
        return (Boolean)operation.call(new Object[]{level, pos, next});
    }

    @Inject(method={"findHoeableSurface"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    private void findHoeableSurface_TAIL(BlockPos pos, FarmField farmField, CallbackInfoReturnable<BlockPos> cir) {
        if (!this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.hoe.get())) {
            this.equipHoe();
        }
        ServerLevel level = this.world;
        IColony colony = this.worker.getCitizenData().getColony();
        InteractionHand hand = this.worker.getUsedItemHand();
        ItemStack hoe = this.worker.getInventoryCitizen().getHeldItem(hand);
        BlockState prev = level.getBlockState(pos);
        BlockState tilled = BlockUtils.getHoeTilledState(colony, (Level)level, pos, hand, hoe, true);
        if (tilled == null || tilled == prev) {
            cir.setReturnValue(null);
        }
    }

    @ModifyVariable(method={"getSurfacePos(Lnet/minecraft/core/BlockPos;Ljava/lang/Integer;)Lnet/minecraft/core/BlockPos;"}, remap=false, at=@At(value="STORE"), ordinal=0)
    private Block getSurfacePos(Block curBlock) {
        if (MineColoniesCompatibility.COMPAT.getStem(curBlock) != null) {
            return Blocks.PUMPKIN;
        }
        return curBlock;
    }
}

