/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_compatibility.api.common.inventory.IRecipeTransferableMenu;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class JEIRecipeTransferMessage<RECIPE, RECIPE_INPUT>
extends AbstractMessage {
    public static final CustomPacketPayload.Type<JEIRecipeTransferMessage<?, ?>> TYPE = new CustomPacketPayload.Type(MineColoniesCompatibility.rl("jei_recipe_transfer"));
    public static final String RECIPE_TRANSFER_TAG_RECIPE = "recipe";
    public static final String RECIPE_TRANSFER_TAG_PAYLOAD = "payload";
    private final CompoundTag tag;

    public JEIRecipeTransferMessage(IRecipeTransferableMenu<RECIPE, RECIPE_INPUT> menu, RECIPE recipe) {
        this(menu, recipe, new CompoundTag());
    }

    public JEIRecipeTransferMessage(IRecipeTransferableMenu<RECIPE, RECIPE_INPUT> menu, RECIPE recipe, CompoundTag payload) {
        RegistryAccess registryAccess = menu.getInventory().player.registryAccess();
        this.tag = new CompoundTag();
        this.tag.put(RECIPE_TRANSFER_TAG_RECIPE, (Tag)menu.getRecipeValidator().serialize((HolderLookup.Provider)registryAccess, (IFactoryController)StandardFactoryController.getInstance(), recipe));
        this.tag.put(RECIPE_TRANSFER_TAG_PAYLOAD, (Tag)payload);
    }

    public JEIRecipeTransferMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.tag = buffer.readNbt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeNbt((Tag)this.tag);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        Player player = context.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IRecipeTransferableMenu) {
            IRecipeTransferableMenu menu = (IRecipeTransferableMenu)abstractContainerMenu;
            RegistryAccess registryAccess = menu.getInventory().player.registryAccess();
            Object recipe = menu.getRecipeValidator().deserialize((HolderLookup.Provider)registryAccess, (IFactoryController)StandardFactoryController.getInstance(), this.tag.getCompound(RECIPE_TRANSFER_TAG_RECIPE));
            CompoundTag payload = this.tag.getCompound(RECIPE_TRANSFER_TAG_PAYLOAD);
            menu.onRecipeTransfer(recipe, payload);
        }
    }

    public CustomPacketPayload.Type<JEIRecipeTransferMessage<?, ?>> type() {
        return TYPE;
    }

    public CompoundTag getTag() {
        return this.tag;
    }
}

