/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_compatibility.api.common.inventory.IItemGhostMenu;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class JEIGhostAcceptItemMessage
extends AbstractMessage {
    public static final CustomPacketPayload.Type<JEIGhostAcceptItemMessage> TYPE = new CustomPacketPayload.Type(MineColoniesCompatibility.rl("jei_ghost_accept_item"));
    private final int slotNumber;
    private final ItemStack stack;
    private final boolean isVirtual;

    public JEIGhostAcceptItemMessage(int slotNumber, ItemStack stack, boolean isVirtual) {
        this.slotNumber = slotNumber;
        this.stack = stack;
        this.isVirtual = isVirtual;
    }

    public JEIGhostAcceptItemMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.slotNumber = buffer.readInt();
        this.stack = ItemSerializationHelper.deserialize((FriendlyByteBuf)buffer);
        this.isVirtual = buffer.readBoolean();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.slotNumber);
        ItemSerializationHelper.serialize((FriendlyByteBuf)buffer, (ItemStack)this.stack);
        buffer.writeBoolean(this.isVirtual);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        Player player = context.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IItemGhostMenu) {
            IItemGhostMenu ghostMenu = (IItemGhostMenu)abstractContainerMenu;
            ghostMenu.onGhostAcceptItem(this.slotNumber, this.stack, this.isVirtual);
        }
    }

    public CustomPacketPayload.Type<JEIGhostAcceptItemMessage> type() {
        return TYPE;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

