/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class BlockEntityRequestModelDataUpdateMessage
extends AbstractMessage {
    public static final CustomPacketPayload.Type<BlockEntityRequestModelDataUpdateMessage> TYPE = new CustomPacketPayload.Type(MineColoniesCompatibility.rl("block_entity_request_model_data_update"));
    private final BlockPos pos;
    private final CompoundTag tag;

    public BlockEntityRequestModelDataUpdateMessage(BlockEntity blockEntity) {
        this.pos = blockEntity.getBlockPos();
        this.tag = blockEntity.getUpdateTag((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
    }

    public BlockEntityRequestModelDataUpdateMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.pos = buffer.readBlockPos();
        this.tag = buffer.readNbt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeBlockPos(this.pos);
        buffer.writeNbt((Tag)this.tag);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        BlockEntity blockEntity = context.player().level().getBlockEntity(this.pos);
        if (blockEntity != null) {
            blockEntity.handleUpdateTag(this.tag, (HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            blockEntity.requestModelDataUpdate();
        }
    }

    public CustomPacketPayload.Type<BlockEntityRequestModelDataUpdateMessage> type() {
        return TYPE;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

