/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.api.util.MessageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModule;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModuleView;
import steve_gall.minecolonies_compatibility.core.common.init.ModDataComponents;
import steve_gall.minecolonies_tweaks.api.common.building.module.ModulePos;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksDataComponents;

public class RestrictToolItem
extends Item
implements IBlockOverlayItem {
    public RestrictToolItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.isClientSide()) {
            ItemStack stack = player.getMainHandItem();
            this.setPos1(stack, pos);
            MessageUtils.format((String)"minecolonies_compatibility.text.restrict.set1", (Object[])new Object[0]).sendTo(new Player[]{player});
            this.updateModuleArea(player, stack);
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide()) {
            Player player = context.getPlayer();
            ItemStack stack = context.getItemInHand();
            this.setPos2(stack, context.getClickedPos());
            MessageUtils.format((String)"minecolonies_compatibility.text.restrict.set2", (Object[])new Object[0]).sendTo(new Player[]{player});
            this.updateModuleArea(player, stack);
        }
        return InteractionResult.FAIL;
    }

    public void setModule(ItemStack stack, IRestrictableModule module, Component moduleDesc) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.empty().append(super.getName(stack)).append(": ").append(moduleDesc));
        stack.set((Supplier)MCTweaksDataComponents.MODULE_POS, (Object)new ModulePos((IBuildingModule)module));
        stack.set(ModDataComponents.BUILDING_NAME, (Object)module.getBuilding().getBuildingDisplayName());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        ModulePos modulePos = this.getModulePos(stack);
        if (modulePos != null) {
            BlockPos pos = modulePos.getBuildingId();
            tooltip.add((Component)Component.translatable((String)"item.minecolonies_compatibility.restrict_tool.name", (Object[])new Object[]{Component.translatable((String)((String)stack.getOrDefault(ModDataComponents.BUILDING_NAME, (Object)"")))}));
            tooltip.add((Component)Component.translatable((String)"item.minecolonies_compatibility.restrict_tool.pos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}));
        }
    }

    @Nullable
    public ModulePos getModulePos(ItemStack stack) {
        return (ModulePos)stack.get((Supplier)MCTweaksDataComponents.MODULE_POS);
    }

    @Nullable
    public IRestrictableModule getModule(ItemStack stack) {
        IRestrictableModule module;
        IBuildingModule iBuildingModule;
        ModulePos pos = this.getModulePos(stack);
        return pos != null && (iBuildingModule = pos.getModule()) instanceof IRestrictableModule ? (module = (IRestrictableModule)iBuildingModule) : null;
    }

    @Nullable
    public IRestrictableModuleView getModuleView(ItemStack stack) {
        IRestrictableModuleView module;
        IBuildingModuleView iBuildingModuleView;
        ModulePos pos = this.getModulePos(stack);
        return pos != null && (iBuildingModuleView = pos.getModuleView()) instanceof IRestrictableModuleView ? (module = (IRestrictableModuleView)iBuildingModuleView) : null;
    }

    public void updateModuleArea(Player player, ItemStack stack) {
        int maxVolume;
        int distZ;
        int distY;
        BlockPos pos1 = this.getPos1(stack);
        BlockPos pos2 = this.getPos2(stack);
        if (pos1 == null || pos2 == null) {
            return;
        }
        IRestrictableModule module = this.getModule(stack);
        if (module == null) {
            return;
        }
        BoundingBox box = BoundingBox.fromCorners((Vec3i)pos1, (Vec3i)pos2);
        int distX = box.maxX() - box.minX() + 1;
        int volume = distX * (distY = box.maxY() - box.minY() + 1) * (distZ = box.maxZ() - box.minZ() + 1);
        if (volume > (maxVolume = (int)Math.floor(2.0 * Math.pow(module.getSearchRange(), 3.0)))) {
            MessageUtils.format((String)"minecolonies_compatibility.text.restrict.too_big", (Object[])new Object[]{volume, maxVolume}).sendTo(new Player[]{player});
            return;
        }
        MessageUtils.format((String)"minecolonies_compatibility.text.restrict.update", (Object[])new Object[]{box.minX(), box.maxX(), box.minY(), box.maxY(), box.minZ(), box.maxZ(), volume, maxVolume}).sendTo(new Player[]{player});
        module.setRestrictArea(pos1, pos2);
    }

    protected void setPos(ItemStack stack, DataComponentType<BlockPos> key, @Nullable BlockPos pos) {
        if (pos == null) {
            stack.remove(key);
        } else {
            stack.set(key, (Object)pos);
        }
    }

    @Nullable
    protected BlockPos getPos(ItemStack stack, DataComponentType<BlockPos> key) {
        return (BlockPos)stack.get(key);
    }

    public void setPos1(ItemStack stack, @Nullable BlockPos pos) {
        this.setPos(stack, (DataComponentType<BlockPos>)((DataComponentType)ModDataComponents.RESTRICT_POS_1.get()), pos);
    }

    public void setPos2(ItemStack stack, @Nullable BlockPos pos) {
        this.setPos(stack, (DataComponentType<BlockPos>)((DataComponentType)ModDataComponents.RESTRICT_POS_2.get()), pos);
    }

    @Nullable
    public BlockPos getPos1(ItemStack stack) {
        return this.getPos(stack, (DataComponentType<BlockPos>)((DataComponentType)ModDataComponents.RESTRICT_POS_1.get()));
    }

    @Nullable
    public BlockPos getPos2(ItemStack stack) {
        return this.getPos(stack, (DataComponentType<BlockPos>)((DataComponentType)ModDataComponents.RESTRICT_POS_2.get()));
    }

    @NotNull
    public List<IBlockOverlayItem.OverlayBox> getOverlayBoxes(@NotNull Level world, @NotNull Player player, @NotNull ItemStack stack) {
        IRestrictableModuleView module = this.getModuleView(stack);
        if (module != null) {
            BlockPos pos = module.getBuildingView().getID();
            BlockPos pos1 = module.getRestrictAreaPos1();
            BlockPos pos2 = module.getRestrictAreaPos2();
            BlockPos p1 = this.getPos1(stack);
            BlockPos p2 = this.getPos2(stack);
            ArrayList<IBlockOverlayItem.OverlayBox> boxes = new ArrayList<IBlockOverlayItem.OverlayBox>();
            if (p1 != null && p2 != null) {
                boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(p1).minmax(new AABB(p2)), -16711936, 0.04f, true));
            } else {
                boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(pos1).minmax(new AABB(pos2)), -16711936, 0.04f, true));
            }
            if (p1 != null) {
                boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(p1), -65536, 0.02f, true));
            }
            if (p2 != null) {
                boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(p2), -16776961, 0.02f, true));
            }
            boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(pos), -1, 0.02f, true));
            return boxes;
        }
        return Collections.emptyList();
    }
}

