/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SmithingTemplateItem;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.init.ModTags;

public class ItemStackHelper {
    public static List<ItemStack> getCraftingRemainings(List<ItemStack> list) {
        return ItemStackHelper.mapAndFilterNotEmpty(list, IItemStackExtension::getCraftingRemainingItem);
    }

    public static List<ItemStack> mapAndFilterNotEmpty(List<ItemStack> inputs, Function<ItemStack, ItemStack> func) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack input : inputs) {
            ItemStack output = func.apply(input);
            if (output.isEmpty()) continue;
            outputs.add(output);
        }
        return outputs;
    }

    public static List<ItemStack> filterNotEmpty(List<ItemStack> inputs) {
        return inputs.stream().filter(stack -> !stack.isEmpty()).toList();
    }

    public static boolean isTool(@NotNull ItemStack stack, @NotNull EquipmentTypeEntry toolType) {
        return toolType.checkIsEquipment(stack);
    }

    @NotNull
    public static EquipmentTypeEntry getFirstToolType(@NotNull ItemStack stack) {
        for (EquipmentTypeEntry toolType : IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry()) {
            if (toolType == ModEquipmentTypes.none.get() || !ItemStackHelper.isTool(stack, toolType)) continue;
            return toolType;
        }
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    public static boolean equals(ItemStack stack1, ItemStack stack2) {
        return ItemStackHelper.equalsIgnoreSize(stack1, stack2) && stack1.getCount() == stack2.getCount();
    }

    public static boolean equalsIgnoreSize(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean isSmithingTemplate(ItemStack stack) {
        return stack.getItem() instanceof SmithingTemplateItem || stack.is(ModTags.Items.SMITHING_TEMPLATES);
    }

    private ItemStackHelper() {
    }
}

