/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class TeachContainer
implements Container {
    private final NonNullList<ItemStack> items;
    private final AbstractContainerMenu menu;

    public TeachContainer(AbstractContainerMenu menu, int count) {
        this.items = NonNullList.withSize((int)count, (Object)ItemStack.EMPTY);
        this.menu = menu;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot >= this.getContainerSize() ? ItemStack.EMPTY : (ItemStack)this.items.get(slot);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
    }

    public void setChanged() {
        this.menu.slotsChanged((Container)this);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
    }
}

