/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.building.module.SmithingTemplateCraftingModule;
import steve_gall.minecolonies_compatibility.core.common.init.ModMenuTypes;
import steve_gall.minecolonies_compatibility.core.common.inventory.ModuleMenu;

public class SmithingTemplateInventoryMenu
extends ModuleMenu {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 86;
    private final IItemHandlerModifiable inventory;

    public SmithingTemplateInventoryMenu(int windowId, Inventory inventory, SmithingTemplateCraftingModule module) {
        super((MenuType)ModMenuTypes.SMITHING_TEMPLATE_INVENTORY.get(), windowId, inventory, (IBuildingModule)module);
        this.inventory = module.getInventory();
        this.setup();
    }

    public SmithingTemplateInventoryMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModMenuTypes.SMITHING_TEMPLATE_INVENTORY.get(), windowId, inventory, buffer);
        this.inventory = new ItemStackHandler(27);
        this.setup();
    }

    private void setup() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            int xi = i % 9;
            int yi = i / 9;
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, i, 8 + 18 * xi, 18 + 18 * yi){

                public int getMaxStackSize(@NotNull ItemStack stack) {
                    return Math.min(this.getMaxStackSize(), stack.getMaxStackSize());
                }
            });
        }
        this.addInventorySlots(8, 86);
    }

    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot != null && slot.hasItem()) {
            int inventorySlots = this.inventory.getSlots();
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotNumber < inventorySlots ? !this.moveItemStackTo(itemstack1, inventorySlots, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, inventorySlots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public IItemHandlerModifiable getModuleInventory() {
        return this.inventory;
    }
}

