/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingCraftingType;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingRecipeAccessor;
import steve_gall.minecolonies_compatibility.core.common.init.ModMenuTypes;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class SmithingTeachMenu
extends TeachRecipeMenu<RecipeHolder<SmithingRecipe>, SmithingRecipeInput> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int TEMPLATE_X = 8;
    public static final int TEMPLATE_Y = 48;
    public static final int BASE_X = 26;
    public static final int BASE_Y = 48;
    public static final int ADDTION_X = 44;
    public static final int ADDTION_Y = 48;
    public static final int RESULT_X = 98;
    public static final int RESULT_Y = 48;
    private final int buildingLevel;

    public SmithingTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModMenuTypes.SMITHING_TEACH.get(), windowId, inventory, module);
        this.buildingLevel = module.getBuilding().getBuildingLevel();
        this.setup();
    }

    public SmithingTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModMenuTypes.SMITHING_TEACH.get(), windowId, inventory, buffer);
        this.buildingLevel = buffer.readInt();
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 3);
        this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, 0, 8, 48)));
        this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, 1, 26, 48)));
        this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, 2, 44, 48)));
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.addSlot(new TeachResultSlot(this.resultContainer, 0, 98, 48)));
    }

    @Override
    protected IMenuRecipeValidator<RecipeHolder<SmithingRecipe>, SmithingRecipeInput> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<SmithingRecipe, SmithingRecipeInput>(this, this.inventory.player.level()){

            @Override
            public RecipeType<SmithingRecipe> getRecipeType() {
                return RecipeType.SMITHING;
            }

            @Override
            @NotNull
            public SmithingRecipeInput getInput(Container container, RecipeHolder<SmithingRecipe> recipe) {
                return new SmithingRecipeInput(container.getItem(0), container.getItem(1), container.getItem(2));
            }
        };
    }

    @Override
    @Nullable
    public Component getCurrentError() {
        Component error = this.getRecipeError((SmithingRecipeInput)this.getRecipeInput((RecipeHolder)this.recipe));
        if (error != null) {
            return error;
        }
        return super.getCurrentError();
    }

    @Override
    @Nullable
    public Component getRecipeError(SmithingRecipeInput input) {
        return this.testRequiredLevel(SmithingCraftingType.getRequiredLevel(input.addition()));
    }

    @Override
    public Component getRecipeError(RecipeHolder<SmithingRecipe> recipe) {
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof SmithingRecipeAccessor) {
            SmithingRecipeAccessor accessor = (SmithingRecipeAccessor)recipe2;
            Ingredient addition = accessor.getAddition();
            Component error = this.testRequiredLevel(SmithingCraftingType.getRequiredMinLevel(addition));
            if (error != null) {
                return error;
            }
            return super.getRecipeError(recipe);
        }
        return TEXT_RECIPE_NOT_SUPPORTED;
    }

    public Component testRequiredLevel(int requiredLevel) {
        if (this.buildingLevel < requiredLevel) {
            int maxLevel = 5;
            if (requiredLevel == maxLevel) {
                return Component.translatable((String)"com.minecolonies.coremod.jei.onelevelrestriction.tip", (Object[])new Object[]{requiredLevel});
            }
            return Component.translatable((String)"com.minecolonies.coremod.jei.levelrestriction.tip", (Object[])new Object[]{requiredLevel, maxLevel});
        }
        return null;
    }

    @Override
    protected void setContainerByTransfer(@NotNull HolderLookup.Provider provider, @NotNull RecipeHolder<SmithingRecipe> recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(provider, recipe, payload);
        ListTag input = payload.getList("input", 10);
        this.inputContainer.setItem(0, ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)input.getCompound(0)));
        this.inputContainer.setItem(1, ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)input.getCompound(1)));
        this.inputContainer.setItem(2, ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)input.getCompound(2)));
    }

    @Override
    protected void onRecipeChanged(HolderLookup.Provider provider, SmithingRecipeInput input) {
        if (this.recipe != null) {
            this.resultContainer.setItem(0, ((SmithingRecipe)((RecipeHolder)this.recipe).value()).assemble((RecipeInput)input, provider));
        } else {
            this.resultContainer.setItem(0, ItemStack.EMPTY);
        }
    }
}

