/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.IStateSupplier;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.BuildingStatisticsModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.network.messages.client.CompostParticleMessage;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.building.module.FruitListModule;
import steve_gall.minecolonies_compatibility.core.common.colony.CitizenHelper;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.Fruit;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.OrchardistAIState;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.OrchardistConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.pathfinding.FruitPathResult;
import steve_gall.minecolonies_compatibility.core.common.entity.pathfinding.PathJobFindFruit;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;
import steve_gall.minecolonies_compatibility.core.common.job.JobOrchardist;

public class EntityAIWorkOrchardist
extends AbstractEntityAIInteract<JobOrchardist, BuildingLumberjack> {
    public static final VisibleCitizenStatus SEARCH = new VisibleCitizenStatus(ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"textures/icons/work/lumberjack_search.png"), "com.minecolonies.gui.visiblestatus.lumberjack_search");
    public static final double XP_PER_HARVEST = 0.5;
    public static final ISettingKey<BoolSetting> FERTILIZE = BuildingFarmer.FERTILIZE;
    public static final ISettingKey<BoolSetting> NEED_MAX_HARVEST = new SettingKey(BoolSetting.class, MineColoniesCompatibility.rl("need_max_harvest"));
    public static final List<Item> COMPOST_ITEMS = Arrays.asList(ModItems.compost, Items.BONE_MEAL);
    @Nullable
    private FruitPathResult pathResult;
    private long nextSearchDelay = -1L;

    public static boolean isCompost(ItemStack stack) {
        return COMPOST_ITEMS.contains(stack.getItem());
    }

    public EntityAIWorkOrchardist(@NotNull JobOrchardist job) {
        super((AbstractJob)job);
        this.registerTargets(new TickingTransition[]{new AITarget((IState)AIWorkerState.IDLE, (IStateSupplier & Serializable)() -> AIWorkerState.START_WORKING, 1), new AITarget((IState)AIWorkerState.START_WORKING, this::decide, 5), new AITarget((IState)AIWorkerState.PREPARING, this::prepare, 5), new AITarget((IState)OrchardistAIState.SEARCH, this::search, 5), new AITarget((IState)OrchardistAIState.HARVEST, this::harvest, 5)});
        this.worker.setCanPickUpLoot(true);
    }

    public void tick() {
        if (this.nextSearchDelay > 0L) {
            this.nextSearchDelay -= 5L;
        }
        super.tick();
    }

    public Class<BuildingLumberjack> getExpectedBuildingClass() {
        return BuildingLumberjack.class;
    }

    protected int getActionsDoneUntilDumping() {
        OrchardistConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.orchardist;
        return (Integer)config.actionsDoneUntilDumping.get();
    }

    private IAIState decide() {
        int amountOfCompostInInv;
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        BuildingLumberjack building = (BuildingLumberjack)this.building;
        AbstractEntityCitizen worker = this.worker;
        int amountOfCompostInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)building, EntityAIWorkOrchardist::isCompost, (int)1);
        if (amountOfCompostInBuilding + (amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)worker.getInventoryCitizen(), EntityAIWorkOrchardist::isCompost)) <= 0) {
            ICitizenData citizenData = worker.getCitizenData();
            if (((BoolSetting)building.getSetting(FERTILIZE)).getValue().booleanValue() && !building.hasWorkerOpenRequestsOfType(citizenData.getId(), TypeToken.of(StackList.class))) {
                List<ItemStack> compostAbleItems = COMPOST_ITEMS.stream().map(i -> new ItemStack((ItemLike)i, 1)).toList();
                citizenData.createRequestAsync((IRequestable)new StackList(compostAbleItems, "com.minecolonies.coremod.request.fertilizer", 64, 1));
            }
        } else if (amountOfCompostInInv <= 0 && amountOfCompostInBuilding > 0) {
            this.needsCurrently = new Tuple(EntityAIWorkOrchardist::isCompost, (Object)64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepare() {
        if (this.nextSearchDelay > 0L) {
            return this.getState();
        }
        return OrchardistAIState.SEARCH;
    }

    private boolean equipTool(EquipmentTypeEntry toolType) {
        if (this.checkForToolOrWeapon(toolType)) {
            return true;
        }
        int slot = CitizenHelper.getMaxLevelToolSlot(this.worker.getCitizenData(), toolType);
        CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.worker, (InteractionHand)InteractionHand.MAIN_HAND, (int)slot);
        return false;
    }

    private IAIState search() {
        if (this.pathResult == null) {
            ((JobOrchardist)this.job).setFruit(null);
            this.worker.getCitizenData().setVisibleStatus(SEARCH);
            this.pathResult = this.creatNewPath();
            return this.getState();
        }
        if (this.pathResult.isDone()) {
            return this.onPathDone();
        }
        return this.getState();
    }

    private FruitPathResult creatNewPath() {
        ServerLevel level = this.world;
        AbstractEntityCitizen worker = this.worker;
        BuildingLumberjack building = (BuildingLumberjack)this.building;
        BlockPos start = PathfindingUtils.prepareStart((LivingEntity)worker);
        BlockPos buildingPos = building.getPosition();
        OrchardistConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.orchardist;
        PathJobFindFruit job = null;
        if (building.shouldRestrict()) {
            BoundingBox restrictionBox = BoundingBox.fromCorners((Vec3i)building.getStartRestriction(), (Vec3i)building.getEndRestriction());
            job = new PathJobFindFruit((Level)level, start, restrictionBox, (Mob)worker);
        } else {
            int range = (Integer)config.searchRange.get();
            job = new PathJobFindFruit((Level)level, start, buildingPos, range, (Mob)worker);
        }
        job.vertialRange = (Integer)config.searchVerticalRange.get();
        job.canBoneMeal = InventoryUtils.getItemCountInItemHandler((IItemHandler)worker.getInventoryCitizen(), EntityAIWorkOrchardist::isCompost) > 0;
        job.needMaxHarvest = ((BoolSetting)building.getSetting(NEED_MAX_HARVEST)).getValue();
        job.exceptFruits.addAll(((FruitListModule)building.getModule(ModBuildingModules.FRUITLIST_BLACKLIST)).getIds());
        return (FruitPathResult)((MinecoloniesAdvancedPathNavigate)worker.getNavigation()).setPathJob((AbstractPathJob)job, null, 1.0, true);
    }

    private IAIState onPathDone() {
        Fruit fruit = this.pathResult.fruit;
        this.pathResult = null;
        if (fruit == null) {
            OrchardistConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.orchardist;
            this.nextSearchDelay = ((Integer)config.searchDelayAfterNotFound.get()).intValue();
            return AIWorkerState.INVENTORY_FULL;
        }
        ((JobOrchardist)this.job).setFruit(fruit);
        return OrchardistAIState.HARVEST;
    }

    private IAIState harvest() {
        ServerLevel level = this.world;
        AbstractEntityCitizen worker = this.worker;
        BuildingLumberjack building = (BuildingLumberjack)this.building;
        JobOrchardist job = (JobOrchardist)this.job;
        Fruit fruit = job.getFruit();
        if (fruit == null) {
            return OrchardistAIState.SEARCH;
        }
        BlockPos position = fruit.getPosition();
        if (building.shouldRestrict() && !BlockPosUtil.isInArea((BlockPos)building.getStartRestriction(), (BlockPos)building.getEndRestriction(), (BlockPos)position)) {
            return OrchardistAIState.SEARCH;
        }
        if (!fruit.updateAndIsValid((LevelReader)level)) {
            return OrchardistAIState.SEARCH;
        }
        if (((FruitListModule)building.getModule(ModBuildingModules.FRUITLIST_BLACKLIST)).containsId(fruit.getFruit().getId())) {
            return AIWorkerState.START_WORKING;
        }
        if (this.equipTool(fruit.getToolType())) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(position) || this.hasNotDelayed(this.getLevelDelay())) {
            return this.getState();
        }
        InventoryCitizen inventory = worker.getInventoryCitizen();
        InteractionHand hand = worker.getUsedItemHand();
        BlockState state = fruit.getContext().getState();
        if (!fruit.canHarvest(((BoolSetting)building.getSetting(NEED_MAX_HARVEST)).getValue())) {
            BonemealableBlock block;
            Block block2 = state.getBlock();
            if (block2 instanceof BonemealableBlock && (block = (BonemealableBlock)block2).isValidBonemealTarget((LevelReader)level, position, state)) {
                if (!InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)inventory, EntityAIWorkOrchardist::isCompost)) {
                    return OrchardistAIState.SEARCH;
                }
                worker.swing(hand);
                if (block.isBonemealSuccess((Level)level, level.random, position, state) && level instanceof ServerLevel) {
                    ServerLevel serverLevel = level;
                    new CompostParticleMessage(position.above()).sendToTargetPoint(serverLevel, null, (double)position.getX(), (double)position.getY(), (double)position.getZ(), 16.0);
                    block.performBonemeal(serverLevel, serverLevel.random, position, state);
                }
                return this.getState();
            }
            return OrchardistAIState.SEARCH;
        }
        HarvesterContext harvester = new HarvesterContext((LivingEntity)worker, inventory.getHeldItem(hand));
        List<ItemStack> drops = fruit.harvest(harvester);
        level.playSound(null, position, fruit.getSound(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        for (ItemStack stack : drops) {
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((ItemStack)stack, (IItemHandler)inventory);
        }
        worker.swing(hand);
        CitizenItemUtils.damageItemInHand((AbstractEntityCitizen)worker, (InteractionHand)hand, (int)1);
        IColony colony = worker.getCitizenColonyHandler().getColony();
        colony.getStatisticsManager().increment("crops_harvested", colony.getDay());
        worker.getCitizenExperienceHandler().addExperience(0.5);
        this.incrementActionsDone();
        worker.decreaseSaturationForContinuousAction();
        this.onBlockDropReception(drops);
        if (fruit.updateAndIsValid((LevelReader)level)) {
            return this.getState();
        }
        return OrchardistAIState.SEARCH;
    }

    private int getLevelDelay() {
        OrchardistConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.orchardist;
        int reduce = (int)((double)this.getPrimarySkillLevel() * (Double)config.harvestDelayReducePerSkillLevel.get());
        return Math.max(1, (Integer)config.harvestDelay.get() - reduce);
    }

    public void onBlockDropReception(List<ItemStack> blockDrops) {
        super.onBlockDropReception(blockDrops);
        for (ItemStack stack : blockDrops) {
            ((BuildingStatisticsModule)((BuildingLumberjack)this.building).getModule(BuildingModules.STATS_MODULE)).incrementBy("item_obtained;" + stack.getItem().getDescriptionId(), stack.getCount());
        }
    }
}

