/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai.guard;

import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobWalkRandomEdge;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.CustomizableEntityAIGuard;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.GunnerCombatAI;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;
import steve_gall.minecolonies_compatibility.core.common.job.JobGunner;

public class EntityAIGunner
extends CustomizableEntityAIGuard<JobGunner, AbstractBuildingGuards> {
    public EntityAIGunner(@NotNull JobGunner job) {
        super(job);
        this.toolsNeeded.add(ModToolTypes.GUN.getToolType());
        new GunnerCombatAI((EntityCitizen)this.worker, this.getStateAI(), this);
    }

    @Override
    @Nullable
    public EquipmentTypeEntry getHandToolType() {
        return ModToolTypes.GUN.getToolType();
    }

    public void guardMovement() {
        AbstractEntityCitizen worker = this.worker;
        IGuardBuilding buildingGuards = this.buildingGuards;
        BlockPos guardPos = buildingGuards.getGuardPos(worker);
        if (worker.getRandom().nextInt(30) < 1) {
            this.walkToSafePos(guardPos);
            return;
        }
        if (!worker.getNavigation().isDone()) {
            return;
        }
        if (BlockPosUtil.dist((BlockPos)guardPos, (BlockPos)worker.blockPosition()) <= 10.0 || this.walkToSafePos(guardPos)) {
            ((MinecoloniesAdvancedPathNavigate)worker.getNavigation()).setPathJob((AbstractPathJob)new PathJobWalkRandomEdge((Level)this.world, guardPos, 10, (Mob)worker), null, 1.0, true);
        }
    }
}

