/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public class SmithingTemplateRecipeStorage
implements ICustomizedRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("smithing_template");
    public static final String TAG_GRID_SIZE = "gridSize";
    public static final String TAG_INPUT = "input";
    public static final String TAG_INPUT_TEMPLATE_COUNT = "inputTemplateCount";
    public static final String TAG_PRIMARY_OUTPUT = "primaryOutput";
    public static final String TAG_SECONDARY_OUTPUTS = "secondaryOutputs";
    private final int gridSize;
    private final List<ItemStorage> input;
    private final int inputTemplateCount;
    private final ItemStack primaryOutput;
    private final List<ItemStack> secondaryOutputs;

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag, SmithingTemplateRecipeStorage recipe) {
        tag.putInt(TAG_GRID_SIZE, recipe.gridSize);
        NBTUtils2.serializeCollection(tag, TAG_INPUT, recipe.input, SerializationHelper.serializerTag((HolderLookup.Provider)provider));
        tag.putInt(TAG_INPUT_TEMPLATE_COUNT, recipe.inputTemplateCount);
        tag.put(TAG_PRIMARY_OUTPUT, (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)recipe.primaryOutput));
        NBTUtils2.serializeCollection(tag, TAG_SECONDARY_OUTPUTS, recipe.secondaryOutputs, ItemSerializationHelper.serializerTag((HolderLookup.Provider)provider));
    }

    public static SmithingTemplateRecipeStorage deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        int gridSize = tag.getInt(TAG_GRID_SIZE);
        List<ItemStorage> input = NBTUtils2.deserializeList(tag, TAG_INPUT, SerializationHelper.deserializerTag((HolderLookup.Provider)provider));
        int inputTemplateCount = tag.getInt(TAG_INPUT_TEMPLATE_COUNT);
        ItemStack primaryOutput = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_PRIMARY_OUTPUT));
        List<ItemStack> secondaryOutputs = NBTUtils2.deserializeList(tag, TAG_SECONDARY_OUTPUTS, ItemSerializationHelper.deserializerTag((HolderLookup.Provider)provider));
        return new SmithingTemplateRecipeStorage(gridSize, input, inputTemplateCount, primaryOutput, secondaryOutputs);
    }

    public SmithingTemplateRecipeStorage(int gridSize, List<ItemStorage> input, int inputTemplateCount, ItemStack primaryOutput, List<ItemStack> secondaryOutputs) {
        this.gridSize = gridSize;
        this.input = input.stream().map(ItemStorage::copy).toList();
        this.inputTemplateCount = inputTemplateCount;
        this.primaryOutput = primaryOutput.copy();
        this.secondaryOutputs = secondaryOutputs.stream().map(ItemStack::copy).toList();
    }

    public int hashCode() {
        return Objects.hash(this.gridSize, this.input, this.inputTemplateCount, this.primaryOutput.getItem(), this.hashCodeItemStacks(this.secondaryOutputs));
    }

    private int hashCodeItemStacks(List<ItemStack> stacks) {
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        for (ItemStack item : stacks) {
            map.put(item.getItem(), item.getCount());
        }
        return map.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SmithingTemplateRecipeStorage) {
            SmithingTemplateRecipeStorage other = (SmithingTemplateRecipeStorage)o;
            if (this.gridSize != other.gridSize || !this.input.equals(other.input) || this.inputTemplateCount != other.inputTemplateCount) {
                return false;
            }
            if (!ItemStackHelper.equals(this.primaryOutput, other.primaryOutput)) {
                return false;
            }
            if (this.secondaryOutputs.size() != other.secondaryOutputs.size()) {
                return false;
            }
            for (int i = 0; i < this.secondaryOutputs.size(); ++i) {
                if (ItemStackHelper.equals(this.secondaryOutputs.get(i), other.secondaryOutputs.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public List<ItemStorage> getInput() {
        return this.input;
    }

    public int getInputTemplateCount() {
        return this.inputTemplateCount;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public ItemStack getPrimaryOutput() {
        return this.primaryOutput;
    }

    public List<ItemStack> getAlternateOutputs() {
        return Collections.emptyList();
    }

    public List<ItemStack> getSecondaryOutputs() {
        return this.secondaryOutputs;
    }

    public Block getIntermediate() {
        return Blocks.AIR;
    }

    public ResourceLocation getRecipeSource() {
        return null;
    }

    public ResourceLocation getRecipeType() {
        return null;
    }

    public ResourceKey<LootTable> getLootTable() {
        return null;
    }

    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }
}

