/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.BucketFillingGenericRecipe;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class BucketFillingRecipeStorage
extends GenericedRecipeStorage<BucketFillingGenericRecipe> {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("bucket_filling");
    public static String TAG_EMPTY_BUCKET = "emptyBucket";
    public static String TAG_FLUID = "fluid";
    public static String TAG_FLUID_AMOUNT = "fluidAmount";
    public static String TAG_DATA_COMPONENT_PATCH = "dataComponentPatch";
    public static String TAG_FILLED_BUCKET = "filledBucket";
    private final ItemStack emptyBucket;
    private final Fluid fluid;
    private final int fluidAmount;
    private final DataComponentPatch dataComponentPatch;
    private final ItemStack filledBucket;
    private final List<ItemStorage> input;
    private final BucketFillingGenericRecipe recipe;

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag, BucketFillingRecipeStorage recipe) {
        tag.put(TAG_EMPTY_BUCKET, (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)recipe.emptyBucket));
        tag.putString(TAG_FLUID, BuiltInRegistries.FLUID.getKey((Object)recipe.fluid).toString());
        tag.putInt(TAG_FLUID_AMOUNT, recipe.fluidAmount);
        tag.put(TAG_DATA_COMPONENT_PATCH, (Tag)DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)recipe.dataComponentPatch).getOrThrow());
        tag.put(TAG_FILLED_BUCKET, (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)recipe.filledBucket));
    }

    public static BucketFillingRecipeStorage deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        ItemStack emptyBucket = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_EMPTY_BUCKET));
        ResourceLocation fluidId = ResourceLocation.parse((String)tag.getString(TAG_FLUID));
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidId);
        int fluidAmount = tag.contains(TAG_FLUID_AMOUNT) ? tag.getInt(TAG_FLUID_AMOUNT) : 1000;
        DataComponentPatch dataComponentPatch = (DataComponentPatch)((Pair)DataComponentPatch.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(TAG_DATA_COMPONENT_PATCH)).getOrThrow()).getFirst();
        ItemStack filledBucket = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_FILLED_BUCKET));
        return new BucketFillingRecipeStorage(emptyBucket, fluid, fluidAmount, dataComponentPatch, filledBucket);
    }

    public BucketFillingRecipeStorage(ItemStack emptyBucket, Fluid fluid, int fluidAmount, DataComponentPatch dataComponentPatch, ItemStack filledBucket) {
        this.emptyBucket = emptyBucket;
        this.fluid = fluid;
        this.fluidAmount = fluidAmount;
        this.dataComponentPatch = dataComponentPatch;
        this.filledBucket = filledBucket;
        this.input = Collections.singletonList(new ItemStorage(emptyBucket));
        this.recipe = new BucketFillingGenericRecipe(emptyBucket, fluid, fluidAmount, dataComponentPatch, filledBucket);
    }

    public int hashCode() {
        return Objects.hash(this.emptyBucket.getItem().hashCode(), this.fluid.hashCode(), this.fluidAmount, this.dataComponentPatch == null ? 0 : this.dataComponentPatch.hashCode(), this.filledBucket.getItem().hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BucketFillingRecipeStorage) {
            BucketFillingRecipeStorage other = (BucketFillingRecipeStorage)o;
            return ItemStack.matches((ItemStack)this.emptyBucket, (ItemStack)other.emptyBucket) && this.fluid == other.fluid && this.fluidAmount == other.fluidAmount && Objects.equals(this.dataComponentPatch, other.dataComponentPatch) && ItemStack.matches((ItemStack)this.filledBucket, (ItemStack)other.filledBucket);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getEmptyBucket() {
        return this.emptyBucket;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public DataComponentPatch getDataComponentPatch() {
        return this.dataComponentPatch;
    }

    public FluidStack getFluidStack() {
        return this.getFluidStack(this.fluidAmount);
    }

    public FluidStack getFluidStack(int amount) {
        FluidStack stack = new FluidStack(this.fluid, amount);
        stack.applyComponents(this.dataComponentPatch);
        return stack;
    }

    public ItemStack getFilledBucket() {
        return this.filledBucket;
    }

    public List<ItemStorage> getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public BucketFillingGenericRecipe getGenericRecipe() {
        return this.recipe;
    }
}

