/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.items.ModItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.crafting.BucketFillingRecipeStorage;

public class BucketFillingCraftingType
extends CraftingType {
    public BucketFillingCraftingType(@NotNull ResourceLocation id) {
        super(id);
    }

    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable Level world) {
        return Collections.emptyList();
    }

    public static BucketFillingRecipeStorage parse(ItemStack filledBucket) {
        FluidActionResult fillResult;
        FluidStack fluidStack;
        Fluid fluid;
        if (filledBucket.is(ModItems.large_water_bottle)) {
            return new BucketFillingRecipeStorage(new ItemStack((ItemLike)ModItems.large_empty_bottle), (Fluid)Fluids.WATER, 1000, DataComponentPatch.EMPTY, filledBucket);
        }
        if (filledBucket.is(ModItems.large_milk_bottle)) {
            return new BucketFillingRecipeStorage(new ItemStack((ItemLike)ModItems.large_empty_bottle), (Fluid)NeoForgeMod.MILK.get(), 1000, DataComponentPatch.EMPTY, filledBucket);
        }
        FluidTank tank = new FluidTank(1000);
        FluidActionResult emptyResult = FluidUtil.tryEmptyContainer((ItemStack)filledBucket, (IFluidHandler)tank, (int)tank.getCapacity(), null, (boolean)true);
        ItemStack emptyBucket = emptyResult.getResult();
        if (emptyResult.isSuccess() && emptyBucket.getItem() == Items.BUCKET && !(fluid = (fluidStack = tank.getFluid()).getFluid()).isSame(Fluids.EMPTY) && fluid.isSource(fluid.defaultFluidState()) && (fillResult = FluidUtil.tryFillContainer((ItemStack)emptyBucket, (IFluidHandler)tank, (int)tank.getCapacity(), null, (boolean)true)).isSuccess() && ItemStack.matches((ItemStack)fillResult.getResult(), (ItemStack)filledBucket)) {
            return new BucketFillingRecipeStorage(emptyBucket, fluid, tank.getCapacity(), fluidStack.getComponentsPatch(), filledBucket);
        }
        return null;
    }
}

