/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.colony;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CitizenHelper {
    public static int getMaxLevelToolSlot(@NotNull ICitizenData citizen, @NotNull EquipmentTypeEntry toolType) {
        InventoryCitizen inventory = citizen.getInventory();
        int maxToolLevel = citizen.getWorkBuilding().getMaxEquipmentLevel();
        return InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)inventory, (EquipmentTypeEntry)toolType, (int)0, (int)maxToolLevel);
    }

    public static JobEntry getJobEntry(@NotNull ICitizenData citizen) {
        IJob job = citizen.getJob();
        return job != null ? job.getJobRegistryEntry() : null;
    }

    public static <R> List<IRequest<? extends R>> getRequests(@NotNull ICitizenData citizen, @NotNull TypeToken<R> token, @NotNull Predicate<IRequest<? extends R>> predicate) {
        IBuilding building = citizen.getWorkBuilding();
        ArrayList<IRequest<R>> list = new ArrayList<IRequest<R>>();
        list.addAll((Collection<IRequest<R>>)building.getOpenRequestsOfTypeFiltered(citizen, token, predicate));
        list.addAll((Collection<IRequest<R>>)building.getCompletedRequestsOfTypeFiltered(citizen, token, predicate));
        return list;
    }

    public static <R> boolean isRequested(@NotNull ICitizenData citizen, @NotNull TypeToken<R> token, @NotNull Predicate<IRequest<? extends R>> predicate) {
        IBuilding building = citizen.getWorkBuilding();
        if (!building.getOpenRequestsOfTypeFiltered(citizen, token, predicate).isEmpty()) {
            return true;
        }
        return !building.getCompletedRequestsOfTypeFiltered(citizen, token, predicate).isEmpty();
    }

    private CitizenHelper() {
    }
}

