/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.block.entity;

import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.block.entity.IAccessDirectionHolder;
import steve_gall.minecolonies_compatibility.core.common.block.entity.INetworkStorageViewHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.AccessDirection;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.init.ModBlockEntities;
import steve_gall.minecolonies_compatibility.core.common.init.ModItems;
import steve_gall.minecolonies_compatibility.core.common.item.CombinedItemHandler;
import steve_gall.minecolonies_compatibility.core.common.item.ItemHandlerHelper2;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackCounter;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackKey;

public class CommonNetworkStorageBlockEntity
extends BlockEntity
implements INetworkStorageViewHolder,
IAccessDirectionHolder {
    private final StorageView view;
    private final ItemStackCounter counter;
    private AccessDirection accessDirection = AccessDirection.INSERT_EXTRACT;

    public CommonNetworkStorageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.COMMON_NETWORK_STORAGE.get(), pos, state);
        this.view = new StorageView();
        this.counter = new ItemStackCounter();
        this.counter.addListener(this::onCounterChanged);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.view.readLink(compound.getCompound("view"));
        this.accessDirection = AccessDirection.deserialize(compound.get("accessDirection"));
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("view", (Tag)this.view.writeLink());
        compound.put("accessDirection", this.accessDirection.serialize());
    }

    @Override
    @NotNull
    public INetworkStorageView getNetworkStorageView() {
        return this.view;
    }

    @Override
    @NotNull
    public AccessDirection getAccessDirection() {
        return this.accessDirection;
    }

    @Override
    public void setAccessDirection(@NotNull AccessDirection value) {
        if (this.accessDirection != value) {
            this.accessDirection = value;
            this.view.requestAll();
            this.setChanged();
        }
    }

    public void setChanged() {
        Level level = this.level;
        if (level != null) {
            WorldUtil.markChunkDirty((Level)level, (BlockPos)this.getBlockPos());
        }
        super.setChanged();
    }

    public void update() {
        Iterable<Object2LongMap.Entry<ItemStackKey>> stacks = this.getStacks();
        this.counter.replace(stacks);
    }

    private void onCounterChanged(ItemStackKey key, long oldCount, long newCount) {
        if (oldCount < newCount) {
            this.view.enqueue(key.getStack(newCount));
        }
    }

    private Iterable<Object2LongMap.Entry<ItemStackKey>> getStacks() {
        IItemHandler handler = this.getCombinedHandler();
        ItemStackCounter counter = new ItemStackCounter();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack == null || stack.isEmpty()) continue;
            ItemStackKey key = new ItemStackKey(stack);
            counter.insert(key, stack.getCount());
        }
        return counter.entrySet();
    }

    public IItemHandler getCombinedHandler() {
        BlockPos pos = this.getBlockPos();
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        for (Direction direction : Direction.values()) {
            IItemHandler handler;
            BlockEntity be = this.level.getBlockEntity(pos.relative(direction));
            if (be == null || (handler = IItemHandlerCapProvider.wrap((BlockEntity)be).getItemHandlerCap(direction.getOpposite())) == null) continue;
            handlers.add(handler);
        }
        return new CombinedItemHandler((IItemHandler[])handlers.toArray(IItemHandler[]::new));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CommonNetworkStorageBlockEntity self) {
        if (!level.isClientSide()) {
            if (level.getGameTime() % 100L == 0L) {
                self.update();
            }
            self.view.onTick();
        }
    }

    public class StorageView
    extends QueueNetworkStorageView {
        @Override
        public Level getLevel() {
            return CommonNetworkStorageBlockEntity.this.level;
        }

        @Override
        public BlockPos getPos() {
            return CommonNetworkStorageBlockEntity.this.worldPosition;
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return null;
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return new ItemStack((ItemLike)ModItems.COMMON_NETWORK_STORAGE.get());
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean canExtract() {
            return CommonNetworkStorageBlockEntity.this.getAccessDirection().canExtract();
        }

        @Override
        public boolean canInsert() {
            return CommonNetworkStorageBlockEntity.this.getAccessDirection().canInsert();
        }

        @Override
        @NotNull
        public Stream<ItemStack> getAllStacks() {
            return CommonNetworkStorageBlockEntity.this.counter.entrySet().stream().map(e -> ((ItemStackKey)e.getKey()).getStack(e.getLongValue()));
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            CommonNetworkStorageBlockEntity.this.setChanged();
        }

        @Override
        public void unlink() {
            super.unlink();
            CommonNetworkStorageBlockEntity.this.setChanged();
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, boolean simulate) {
            return ItemHandlerHelper2.extractItem(CommonNetworkStorageBlockEntity.this.getCombinedHandler(), stack, simulate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
            return ItemHandlerHelper2.insertItem(CommonNetworkStorageBlockEntity.this.getCombinedHandler(), stack, simulate);
        }
    }
}

