/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.plant;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantPositonContext;

public class PlantBlockContext
extends PlantPositonContext {
    @NotNull
    private final BlockState state;

    public PlantBlockContext(@NotNull LevelReader level, @NotNull BlockPos position, @NotNull BlockState state) {
        super(level, position);
        this.state = state;
    }

    @NotNull
    public List<ItemStack> getDrops(@Nullable HarvesterContext harvester) {
        LivingEntity entity = null;
        ItemStack tool = ItemStack.EMPTY;
        if (harvester != null) {
            entity = harvester.getEntity();
            tool = harvester.getTool();
        }
        return this.getDrops(entity, tool);
    }

    @NotNull
    public List<ItemStack> getDrops(@Nullable LivingEntity entity, @NotNull ItemStack tool) {
        LevelReader levelReader = this.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = this.getState();
            BlockPos position = this.getPosition();
            Optional silkTouch = level.registryAccess().holder(Enchantments.SILK_TOUCH);
            if (silkTouch.isPresent()) {
                tool = tool.copy();
                ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)tool));
                map.set((Holder)silkTouch.get(), 0);
                EnchantmentHelper.setEnchantments((ItemStack)tool, (ItemEnchantments)map.toImmutable());
            }
            return Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)position, null, (Entity)entity, (ItemStack)tool);
        }
        return Collections.emptyList();
    }

    @NotNull
    public BlockState getState() {
        return this.state;
    }

    public static void replant(@NotNull PlantBlockContext context, @NotNull List<ItemStack> drops, BlockState replantState) {
        LevelReader levelReader;
        Block block = context.getState().getBlock();
        boolean canReplant = false;
        for (int i = 0; i < drops.size(); ++i) {
            BlockItem item;
            ItemStack stack = drops.get(i);
            Item item2 = stack.getItem();
            if (!(item2 instanceof BlockItem) || (item = (BlockItem)item2).getBlock() != block) continue;
            canReplant = true;
            stack.shrink(1);
            if (!stack.isEmpty()) break;
            drops.remove(i);
            break;
        }
        if ((levelReader = context.getLevel()) instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            level.setBlock(context.getPosition(), canReplant ? replantState : Blocks.AIR.defaultBlockState(), 2);
        }
    }
}

