/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.plant;

import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public abstract class CustomizedFruit {
    private static final Map<ResourceLocation, CustomizedFruit> REGISTRY = new HashMap<ResourceLocation, CustomizedFruit>();

    public static void register(@NotNull CustomizedFruit fruit) {
        REGISTRY.put(fruit.getId(), fruit);
    }

    public static Map<ResourceLocation, CustomizedFruit> getRegistry() {
        return Collections.unmodifiableMap(REGISTRY);
    }

    @Nullable
    public static CustomizedFruit select(@NotNull PlantBlockContext context) {
        return REGISTRY.values().stream().filter(it -> it.test(context)).findFirst().orElse(null);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @NotNull
    public abstract ResourceLocation getId();

    @NotNull
    public abstract List<ItemStack> getBlockIcons();

    @NotNull
    public abstract List<ItemStack> getItemIcons();

    public abstract boolean test(@NotNull PlantBlockContext var1);

    public abstract boolean canHarvest(@NotNull PlantBlockContext var1);

    public abstract boolean isMaxHarvest(@NotNull PlantBlockContext var1);

    @NotNull
    public abstract List<ItemStack> harvest(@NotNull PlantBlockContext var1, @NotNull HarvesterContext var2);

    @NotNull
    public EquipmentTypeEntry getHarvestToolType() {
        return (EquipmentTypeEntry)ModEquipmentTypes.shears.get();
    }

    @NotNull
    public EquipmentTypeEntry getHarvestToolType(@NotNull PlantBlockContext context) {
        return this.getHarvestToolType();
    }

    @NotNull
    public SoundEvent getHarvestSound(@NotNull PlantBlockContext context) {
        return SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES;
    }
}

