/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.inventory;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.RecipeInputHelper;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;

public abstract class MenuRecipeValidatorRecipe<RECIPE extends Recipe<RECIPE_INPUT>, RECIPE_INPUT extends RecipeInput>
implements IMenuRecipeValidator<RecipeHolder<RECIPE>, RECIPE_INPUT> {
    public static final String TAG_ID = "id";
    @NotNull
    protected final Level level;

    public MenuRecipeValidatorRecipe(@NotNull Level level) {
        this.level = level;
    }

    @Override
    public List<RecipeHolder<RECIPE>> findAll(Container container, ServerPlayer player) {
        return this.level.getRecipeManager().getAllRecipesFor(this.getRecipeType()).stream().filter(recipeHolder -> {
            Recipe recipe = recipeHolder.value();
            if (this.test((RecipeHolder<RECIPE>)recipeHolder, container, player)) {
                return recipe.isSpecial() || !this.level.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) || player.getRecipeBook().contains(recipeHolder) || player.isCreative();
            }
            return false;
        }).toList();
    }

    protected boolean test(RecipeHolder<RECIPE> recipeHolder, Container container, ServerPlayer player) {
        RecipeInput input = (RecipeInput)this.getInput(container, recipeHolder);
        return recipeHolder.value().matches(input, player.level());
    }

    protected boolean matchesWithIngredientsCount(RECIPE recipe, RECIPE_INPUT input) {
        int inputsSize;
        if (!recipe.matches(input, this.level)) {
            return false;
        }
        int ingredientsSize = recipe.getIngredients().size();
        return ingredientsSize == (inputsSize = ItemStackHelper.filterNotEmpty(RecipeInputHelper.getItemStacks(input)).size());
    }

    @Override
    public CompoundTag serialize(HolderLookup.Provider provider, IFactoryController controller, RecipeHolder<RECIPE> recipeHolder) {
        CompoundTag tag = new CompoundTag();
        tag.putString(TAG_ID, recipeHolder.id().toString());
        return tag;
    }

    @Override
    public RecipeHolder<RECIPE> deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        ResourceLocation recipeId = ResourceLocation.parse((String)tag.getString(TAG_ID));
        return this.level.getRecipeManager().byKey(recipeId).orElse(null);
    }

    public abstract RecipeType<RECIPE> getRecipeType();
}

