/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.entity.ai.guard;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.IBooleanConditionSupplier;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.IStateSupplier;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.ai.statemachine.transitions.IStateMachineTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.BuildingStatisticsModule;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.BehaviourStateGroup;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.ai.combat.CombatUtils;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.io.Serializable;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAI;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.ICustomizableEntityAI;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.ICustomizableStateAI;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGuard;

public abstract class CustomizableAISimpleGuard<T extends AbstractEntityAIGuard<J, B>, J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AttackMoveAI<EntityCitizen>
implements ICustomizableStateAI<T> {
    @NotNull
    private final T parentAI;

    @Nullable
    public abstract PathResult<?> createPathResult(@NotNull LivingEntity var1, double var2);

    public CustomizableAISimpleGuard(EntityCitizen owner, ITickRateStateMachine stateMachine, @NotNull T parentAI) {
        super((Mob)owner, stateMachine);
        stateMachine.addTransitionGroup(BehaviourStateGroup.GUARD_ABORT_AND_FIGHT, (IStateMachineTransition)new TickingTransition((IBooleanConditionSupplier & Serializable)() -> this.checkForTarget(), (IStateSupplier & Serializable)() -> CombatAIStates.ATTACKING, 5).withName("busy_checkTarget"));
        stateMachine.addTransitionGroup(BehaviourStateGroup.GUARD_ABORT_AND_FIGHT, (IStateMachineTransition)new TickingTransition((IBooleanConditionSupplier & Serializable)() -> this.searchNearbyTarget(), (IStateSupplier & Serializable)() -> CombatAIStates.ATTACKING, 80).withName("busy_searchTarget"));
        this.parentAI = parentAI;
    }

    public boolean canAttack() {
        CustomizedAI customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            return guard.canAttack((AbstractEntityCitizen)this.user, this.target);
        }
        return false;
    }

    protected void doAttack(LivingEntity target) {
        CustomizedAI customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            EntityCitizen user = (EntityCitizen)this.user;
            user.lookAt((Entity)target, 180.0f, 180.0f);
            guard.doAttack((AbstractEntityCitizen)user, target);
            target.setLastHurtByMob((LivingEntity)user);
            user.swing(InteractionHand.MAIN_HAND);
            user.getNavigation().stop();
            CitizenItemUtils.damageItemInHand((AbstractEntityCitizen)user, (InteractionHand)InteractionHand.MAIN_HAND, (int)1);
        }
    }

    protected IState tryAttack() {
        IState state = super.tryAttack();
        if (state == CombatAIStates.NO_TARGET && this.target != null) {
            return null;
        }
        return state;
    }

    protected boolean skipSearch(LivingEntity entity) {
        AbstractJobGuard jobGuard;
        EntityCitizen citizen;
        IJob iJob;
        if (entity instanceof EntityCitizen && (iJob = (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob()) instanceof AbstractJobGuard && (jobGuard = (AbstractJobGuard)iJob).isAsleep() && ((EntityCitizen)this.user).getSensing().hasLineOfSight((Entity)citizen)) {
            this.getParentAI().setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    public void resetTarget() {
        CustomizedAI customizedAI;
        LivingEntity old = this.target;
        super.resetTarget();
        if (old != null && (customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI()) instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            guard.onTargetReset((AbstractEntityCitizen)this.user, old);
        }
    }

    protected void onTargetDied(LivingEntity entity) {
        T parentAI = this.getParentAI();
        EntityCitizen user = (EntityCitizen)this.user;
        parentAI.incrementActionsDone();
        user.getCitizenExperienceHandler().addExperience(15.0);
        user.getCitizenColonyHandler().getColony().getStatisticsManager().increment("mobs_killed", user.getCitizenColonyHandler().getColony().getDay());
        Object object = entity.getType().getDescription().getContents();
        if (object instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)object;
            ((BuildingStatisticsModule)((AbstractBuildingGuards)((AbstractEntityAIGuard)parentAI).building).getModule(BuildingModules.STATS_MODULE)).increment("mob_killed;" + translatableContents.getKey());
        }
        user.decreaseSaturationForContinuousAction();
        object = ((ICustomizableEntityAI)parentAI).getSelectedAI();
        if (object instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)object;
            guard.onTargetReset((AbstractEntityCitizen)user, entity);
        }
    }

    protected boolean isAttackableTarget(LivingEntity entity) {
        return AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)((AbstractEntityCitizen)this.user), (LivingEntity)entity);
    }

    protected void onTargetChange(LivingEntity newTarget) {
        CombatUtils.notifyGuardsOfTarget((AbstractEntityCitizen)((AbstractEntityCitizen)this.user), (LivingEntity)this.target, (int)1600);
        CustomizedAI customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            guard.onTargetChange((AbstractEntityCitizen)this.user, this.target);
        }
    }

    protected int getAttackDelay() {
        CustomizedAI customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            int attackDelay = guard.getAttackDelay((AbstractEntityCitizen)this.user, this.target);
            return Math.max(attackDelay, 10);
        }
        return super.getAttackDelay();
    }

    protected double getAttackDistance() {
        CustomizedAI customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            return guard.getAttackDistance((AbstractEntityCitizen)this.user, this.target);
        }
        return super.getAttackDistance();
    }

    protected int getSearchRange() {
        CustomizedAI customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            return (int)guard.getHorizontalSearchRange((AbstractEntityCitizen)this.user);
        }
        return super.getSearchRange();
    }

    protected int getYSearchRange() {
        CustomizedAI customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            return (int)guard.getVerticalSearchRange((AbstractEntityCitizen)this.user);
        }
        return super.getYSearchRange();
    }

    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        T parentAI = this.getParentAI();
        CustomizedAI customizedAI = ((ICustomizableEntityAI)parentAI).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            return parentAI.isWithinPersecutionDistance(target.blockPosition(), guard.getAttackDistance((AbstractEntityCitizen)this.user, target));
        }
        return super.isWithinPersecutionDistance(target);
    }

    protected PathResult<?> moveInAttackPosition(LivingEntity target) {
        CustomizedAI customizedAI = ((ICustomizableEntityAI)this.getParentAI()).getSelectedAI();
        if (customizedAI instanceof CustomizedAIGuard) {
            CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
            double speed = guard.getJobPathSpeed((AbstractEntityCitizen)this.user);
            return this.createPathResult(target, speed);
        }
        return super.moveInAttackPosition(target);
    }

    @Override
    @NotNull
    public T getParentAI() {
        return this.parentAI;
    }
}

