/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.butcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherBlockContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherCitizenContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedBucherableRegisterEvent;
import steve_gall.minecolonies_compatibility.api.common.crafting.ToolOrIngredientStack;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;
import steve_gall.minecolonies_compatibility.core.common.util.InteractionMessageHelper;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;

public abstract class CustomizedButcherable {
    private static final Map<ResourceLocation, CustomizedButcherable> REGISTRY = new HashMap<ResourceLocation, CustomizedButcherable>();
    private static final Map<ResourceLocation, CustomizedButcherable> VOLATILE = new HashMap<ResourceLocation, CustomizedButcherable>();

    public static void register(@NotNull CustomizedButcherable butcherable) {
        REGISTRY.put(butcherable.getId(), butcherable);
    }

    public static void registerVolatile(@NotNull CustomizedButcherable butcherable) {
        CustomizedButcherable.register(butcherable);
        VOLATILE.put(butcherable.getId(), butcherable);
    }

    public static void reload(@NotNull RecipeManager recipeManager) {
        VOLATILE.keySet().forEach(REGISTRY::remove);
        VOLATILE.clear();
        CustomizedBucherableRegisterEvent e = new CustomizedBucherableRegisterEvent(CustomizedButcherable::registerVolatile, recipeManager);
        NeoForge.EVENT_BUS.post((Event)e);
    }

    public static Map<ResourceLocation, CustomizedButcherable> getRegistry() {
        return Collections.unmodifiableMap(REGISTRY);
    }

    @Nullable
    public static CustomizedButcherable selectByItem(@NotNull ItemStack item) {
        return REGISTRY.values().stream().filter(it -> it.testItem(item)).findFirst().orElse(null);
    }

    @Nullable
    public static CustomizedButcherable selectByButcheringBlock(@NotNull ButcherBlockContext context) {
        return REGISTRY.values().stream().filter(it -> it.isButcheringBlock(context)).findFirst().orElse(null);
    }

    @Nullable
    public static CustomizedButcherable selectByTableBlock(@NotNull ButcherBlockContext context) {
        return REGISTRY.values().stream().filter(it -> it.isTableBlock(context)).findFirst().orElse(null);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @NotNull
    public abstract ResourceLocation getId();

    @NotNull
    public abstract List<ItemStack> getItemIcons();

    @NotNull
    public abstract List<Ingredient> getOutputIcons();

    @NotNull
    public abstract List<BlockState> getTableIcons();

    @NotNull
    public List<ToolOrIngredientStack> getToolsForIcon() {
        return Collections.singletonList(ToolOrIngredientStack.of((CustomToolType)ModToolTypes.BUTCHER_TOOL));
    }

    @NotNull
    public ToolOrIngredientStack getBlockTool(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        return ToolOrIngredientStack.of((CustomToolType)ModToolTypes.BUTCHER_TOOL);
    }

    @NotNull
    public ToolOrIngredientStack getTableTool(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        return ToolOrIngredientStack.of((CustomToolType)ModToolTypes.BUTCHER_TOOL);
    }

    public boolean testItem(@NotNull ItemStack item) {
        return false;
    }

    public boolean isButcheringBlock(@NotNull ButcherBlockContext context) {
        return false;
    }

    public boolean isTableBlock(@NotNull ButcherBlockContext context) {
        return false;
    }

    public void doButcherBlock(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
    }

    public void doButcherTable(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen, @NotNull InteractionHand itemHand) {
    }

    @NotNull
    public SoundEvent getBlockSound(@NotNull ButcherBlockContext context) {
        return context.getState().getSoundType(context.getLevel(), context.getPosition(), null).getHitSound();
    }

    @NotNull
    public SoundEvent getTableSound(@NotNull ButcherBlockContext context) {
        return context.getState().getSoundType(context.getLevel(), context.getPosition(), null).getHitSound();
    }

    @NotNull
    public Component getTableNotFoundMessage() {
        return InteractionMessageHelper.getWorkingBlockNotFound();
    }
}

