/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.building.module;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IModuleWithExternalBlocks;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.entity.pathfinding.PathJobFindWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.entity.pathfinding.WorkingBlocksPathResult;

public interface IModuleWithExternalWorkingBlocks
extends IModuleWithExternalBlocks {
    @NotNull
    default public PathJobFindWorkingBlocks<?> createWorkingBlocksFindPath(@Nullable AbstractEntityCitizen citizen) {
        return this.createWorkingBlocksFindPath(citizen, this.createPathResult(citizen));
    }

    @NotNull
    default public PathJobFindWorkingBlocks<?> createWorkingBlocksFindPath(@Nullable AbstractEntityCitizen citizen, WorkingBlocksPathResult result) {
        IBuilding building = this.getBuilding();
        Tuple corners = building.getCorners();
        IColony colony = building.getColony();
        PathJobFindWorkingBlocks<WorkingBlocksPathResult> job = new PathJobFindWorkingBlocks<WorkingBlocksPathResult>(colony.getWorld(), citizen != null ? citizen.blockPosition() : building.getID(), BoundingBox.fromCorners((Vec3i)((Vec3i)corners.getA()), (Vec3i)((Vec3i)corners.getB())), (Mob)citizen, result);
        if (citizen != null) {
            job.setPathingOptions(citizen.getNavigation().getPathingOptions());
        } else {
            IResearchEffectManager researchEffects = colony.getResearchManager().getResearchEffects();
            PathingOptions options = job.getPathingOptions();
            options.setEnterDoors(true);
            options.setCanOpenDoors(true);
            options.setCanUseRails(researchEffects.getEffectStrength(ResearchConstants.RAILS) > 0.0);
            options.setCanClimbAdvanced(researchEffects.getEffectStrength(ResearchConstants.VINES) > 0.0);
        }
        return job;
    }

    @NotNull
    default public WorkingBlocksPathResult createPathResult(@Nullable AbstractEntityCitizen citizen) {
        return new WorkingBlocksPathResult(this);
    }

    public boolean requestFindWorkingBlocks();

    public boolean requestFindWorkingBlocks(@Nullable AbstractEntityCitizen var1);

    public boolean addWorkingBlock(@Nullable BlockPos var1);

    public boolean removeWorkingBlock(@Nullable BlockPos var1);

    public boolean containsWorkingBlock(@Nullable BlockPos var1);

    @NotNull
    default public Stream<BlockPos> getWorkingBlocks() {
        Level level = this.getBuilding().getColony().getWorld();
        return this.getRegisteredBlocks().stream().filter(pos -> {
            BlockState state = level.getBlockState(pos);
            if (this.isWorkingBlock((LevelReader)level, (BlockPos)pos, state)) {
                return true;
            }
            this.removeWorkingBlock((BlockPos)pos);
            return false;
        });
    }

    public boolean isWorkingBlock(@NotNull LevelReader var1, @NotNull BlockPos var2, @NotNull BlockState var3);

    @NotNull
    default public BlockPos getWalkingPosition(@NotNull BlockPos pos) {
        return pos;
    }
}

