/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.polymorph;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.client.PolymorphWidgets;
import com.illusivesoulworks.polymorph.api.client.base.AbstractRecipesWidget;
import com.illusivesoulworks.polymorph.api.client.base.IRecipesWidget;
import com.illusivesoulworks.polymorph.common.util.RecipePair;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.client.gui.containers.WindowCrafting;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.client.gui.TeachRecipeScreen;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuSelectMessage;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;

public class PolymorphModule
extends AbstractModule {
    @Override
    protected void onLoad() {
        super.onLoad();
        if (FMLEnvironment.dist.isClient()) {
            PolymorphWidgets.getInstance().registerWidget(new PolymorphWidgets.IRecipesWidgetFactory(this){

                public IRecipesWidget createWidget(AbstractContainerScreen<?> screen) {
                    if (screen instanceof WindowCrafting) {
                        return new AbstractRecipesWidget(this, screen){

                            public Slot getOutputSlot() {
                                AbstractContainerMenu menu = this.containerScreen.getMenu();
                                return menu.getSlot(0);
                            }

                            public void selectRecipe(ResourceLocation id) {
                                PacketDistributor.sendToServer((CustomPacketPayload)new TeachRecipeMenuSelectMessage(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                        };
                    }
                    if (screen instanceof TeachRecipeScreen) {
                        return new AbstractRecipesWidget(this, screen){

                            public Slot getOutputSlot() {
                                TeachRecipeMenu menu = (TeachRecipeMenu)this.containerScreen.getMenu();
                                return menu.getResultSlots().get(0);
                            }

                            public void selectRecipe(ResourceLocation id) {
                                PacketDistributor.sendToServer((CustomPacketPayload)new TeachRecipeMenuSelectMessage(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }

                            public int getXPos() {
                                return ((TeachRecipeScreen)this.containerScreen).getSwitchButtonX();
                            }

                            public int getYPos() {
                                return ((TeachRecipeScreen)this.containerScreen).getSwitchButtonY();
                            }
                        };
                    }
                    return null;
                }
            });
        }
    }

    public static void sendRecipesList(ServerPlayer player, CraftingInput input, ItemStack output) {
        Level level = player.level();
        RegistryAccess registryAccess = level.registryAccess();
        boolean notlimited = !level.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING);
        List<Tuple> tuples = level.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)input, level).stream().filter(holder -> ((CraftingRecipe)holder.value()).isSpecial() || notlimited || player.getRecipeBook().contains(holder) || player.isCreative()).map(holder -> new Tuple(holder, (Object)((CraftingRecipe)holder.value()).assemble((RecipeInput)input, (HolderLookup.Provider)registryAccess))).toList();
        TreeSet<RecipePair> pairs = new TreeSet<RecipePair>();
        ResourceLocation selected = null;
        for (Tuple tuple : tuples) {
            ResourceLocation id = ((RecipeHolder)tuple.getA()).id();
            ItemStack stack = (ItemStack)tuple.getB();
            if (stack.isEmpty()) continue;
            pairs.add(new RecipePair(id, stack));
            if (!ItemStackHelper.equals(output, stack)) continue;
            selected = id;
        }
        PolymorphApi.getInstance().getNetwork().sendRecipesListS2C(player, pairs, selected);
    }

    public static <RECIPE, RECIPE_INPUT> void sendRecipesList(ServerPlayer player, TeachRecipeMenu<RECIPE, RECIPE_INPUT> menu) {
        IMenuRecipeValidator<RECIPE, RECIPE_INPUT> recipeValidator = menu.getRecipeValidator();
        if (recipeValidator instanceof MenuRecipeValidatorRecipe) {
            TreeSet<RecipePair> pairs = new TreeSet<RecipePair>();
            ResourceLocation selected = null;
            List<RECIPE> recipes = menu.getRecipes();
            RegistryAccess registryAccess = menu.getInventory().player.level().registryAccess();
            for (int i = 0; i < recipes.size(); ++i) {
                RecipeHolder holder = (RecipeHolder)recipes.get(i);
                ItemStack result = holder.value().getResultItem((HolderLookup.Provider)registryAccess);
                if (result.isEmpty()) continue;
                pairs.add(new RecipePair(holder.id(), result));
                if (menu.getRecipeIndex() != i) continue;
                selected = holder.id();
            }
            PolymorphApi.getInstance().getNetwork().sendRecipesListS2C(player, pairs, selected);
        }
    }
}

