/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.minecraft;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class CaveVinesFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return BuiltInRegistries.BLOCK.getKey((Object)Blocks.CAVE_VINES);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)Items.GLOW_BERRIES));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)Items.GLOW_BERRIES));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        Block block = context.getState().getBlock();
        return block == Blocks.CAVE_VINES || block == Blocks.CAVE_VINES_PLANT;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        if (((Boolean)state.getValue((Property)CaveVines.BERRIES)).booleanValue()) {
            return true;
        }
        if (state.getBlock() == Blocks.CAVE_VINES) {
            BlockPos belowPos = context.getPosition().below();
            BlockState belowState = context.getLevel().getBlockState(belowPos);
            return !belowState.isAir();
        }
        return false;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public SoundEvent getHarvestSound(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        return (Boolean)state.getValue((Property)CaveVines.BERRIES) != false ? SoundEvents.CAVE_VINES_PICK_BERRIES : state.getSoundType(context.getLevel(), context.getPosition(), null).getBreakSound();
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        BlockState state = context.getState();
        BlockPos position = context.getPosition();
        if (((Boolean)state.getValue((Property)CaveVines.BERRIES)).booleanValue()) {
            LevelReader levelReader = context.getLevel();
            if (levelReader instanceof LevelWriter) {
                LevelWriter level = (LevelWriter)levelReader;
                level.setBlock(position, (BlockState)state.setValue((Property)CaveVines.BERRIES, (Comparable)Boolean.valueOf(false)), 2);
            }
            return Collections.singletonList(new ItemStack((ItemLike)Items.GLOW_BERRIES));
        }
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            level.setBlock(position, Blocks.AIR.defaultBlockState(), 2);
        }
        return Collections.emptyList();
    }
}

