/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_meadow.menu;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import net.satisfy.meadow.core.recipes.WoodcuttingRecipe;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.module.common.lets_do_meadow.init.ModuleMenuTypes;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class WoodcuttingTeachMenu
extends TeachRecipeMenu<RecipeHolder<WoodcuttingRecipe>, RecipeInput> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_X = 44;
    public static final int CRAFTING_Y = 26;
    public static final int RESULT_X = 116;
    public static final int RESULT_Y = 26;

    public WoodcuttingTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.WOODCUTTING_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public WoodcuttingTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.WOODCUTTING_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 1);
        this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, 0, 44, 26)));
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.addSlot(new TeachResultSlot(this.resultContainer, 0, 116, 26)));
    }

    @Override
    protected IMenuRecipeValidator<RecipeHolder<WoodcuttingRecipe>, RecipeInput> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<WoodcuttingRecipe, RecipeInput>(this, this.inventory.player.level()){

            @Override
            public RecipeType<WoodcuttingRecipe> getRecipeType() {
                return (RecipeType)RecipeRegistry.WOODCUTTING.get();
            }

            @Override
            public RecipeInput getInput(Container container, RecipeHolder<WoodcuttingRecipe> recipe) {
                return new RecipeWrapper((IItemHandler)new InvWrapper(container));
            }
        };
    }

    @Override
    protected void setContainerByTransfer(HolderLookup.Provider provider, RecipeHolder<WoodcuttingRecipe> recipe, CompoundTag payload) {
        super.setContainerByTransfer(provider, recipe, payload);
        this.inputContainer.setItem(0, ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)payload.getCompound("input")));
    }

    @Override
    protected void onRecipeChanged(HolderLookup.Provider provider, RecipeInput input) {
        this.resultContainer.setItem(0, this.recipe != null ? ((WoodcuttingRecipe)((RecipeHolder)this.recipe).value()).getResultItem(provider) : ItemStack.EMPTY);
    }
}

