/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_meadow.menu;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import net.satisfy.meadow.core.recipes.CheeseFormRecipe;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.crafting.RecipeHelper;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.lets_do_meadow.init.ModuleMenuTypes;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class CheeseTeachMenu
extends TeachRecipeMenu<RecipeHolder<CheeseFormRecipe>, RecipeInput> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 2;
    public static final int CRAFTING_X = 44;
    public static final int CRAFTING_Y = 26;
    public static final int CRAFTING_COLUMNS = 3;
    public static final int CRAFTING_ROW = 2;
    public static final int RESULT_X = 130;
    public static final int RESULT_Y = 26;

    public CheeseTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.CHEESE_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public CheeseTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.CHEESE_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 2);
        for (int i = 0; i < 2; ++i) {
            this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, i, 44 + i * 18, 26)));
        }
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.addSlot(new TeachResultSlot(this.resultContainer, 0, 130, 26)));
    }

    @Override
    protected IMenuRecipeValidator<RecipeHolder<CheeseFormRecipe>, RecipeInput> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<CheeseFormRecipe, RecipeInput>(this, this.inventory.player.level()){

            @Override
            public RecipeType<CheeseFormRecipe> getRecipeType() {
                return (RecipeType)RecipeRegistry.CHEESE.get();
            }

            @Override
            public RecipeInput getInput(Container container, RecipeHolder<CheeseFormRecipe> recipe) {
                return new RecipeWrapper((IItemHandler)new InvWrapper((Container)new CompoundContainer((Container)new SimpleContainer(1), container)));
            }

            @Override
            protected boolean test(RecipeHolder<CheeseFormRecipe> recipeHolder, Container container, ServerPlayer player) {
                return super.test(recipeHolder, container, player) && RecipeHelper.matchesIngredientCount(recipeHolder.value(), container);
            }
        };
    }

    @Override
    protected void setContainerByTransfer(HolderLookup.Provider provider, RecipeHolder<CheeseFormRecipe> recipe, CompoundTag payload) {
        super.setContainerByTransfer(provider, recipe, payload);
        List input = NBTUtils2.deserializeList(payload, "input", ItemSerializationHelper.deserializerTag((HolderLookup.Provider)provider));
        for (int i = 0; i < 2; ++i) {
            this.inputContainer.setItem(i, i < input.size() ? (ItemStack)input.get(i) : ItemStack.EMPTY);
        }
    }

    @Override
    protected void onRecipeChanged(HolderLookup.Provider provider, RecipeInput input) {
        this.resultContainer.setItem(0, this.recipe != null ? ((CheeseFormRecipe)((RecipeHolder)this.recipe).value()).getResultItem(provider) : ItemStack.EMPTY);
    }
}

