/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.menu;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;
import steve_gall.minecolonies_compatibility.core.common.inventory.ReadOnlySlotsContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleMenuTypes;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipeInput;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttingTeachMenu
extends TeachRecipeMenu<RecipeHolder<CuttingBoardRecipe>, CuttingBoardRecipeInput> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 1;
    public static final int CRAFTING_COLS = 1;
    public static final int CRAFTING_X = 14;
    public static final int CRAFTING_Y = 36;
    public static final int RESULT_X = 73;
    public static final int RESULT_Y = 18;
    public static final int RESULT_COLUMNS = 5;
    private final EquipmentTypeEntry toolType;
    private List<ChanceResult> results;

    public CuttingTeachMenu(int windowId, Inventory inventory, IBuildingModule module, EquipmentTypeEntry toolType) {
        super((MenuType)ModuleMenuTypes.CUTTING_TEACH.get(), windowId, inventory, module);
        this.toolType = toolType;
        this.setup();
    }

    public CuttingTeachMenu(int windowId, Inventory inventory, RegistryFriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.CUTTING_TEACH.get(), windowId, inventory, (FriendlyByteBuf)buffer);
        this.toolType = (EquipmentTypeEntry)IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry().get(buffer.readResourceLocation());
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 1);
        for (int i2 = 0; i2 < 1; ++i2) {
            int col = i2 % 1;
            int row = i2 / 1;
            this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, i2, 14 + col * 18, 36 + row * 18)));
        }
        this.results = new ArrayList<ChanceResult>();
        this.resultContainer = new ReadOnlySlotsContainer(this.results::size, i -> this.results.get(i).stack());
    }

    @Override
    protected IMenuRecipeValidator<RecipeHolder<CuttingBoardRecipe>, CuttingBoardRecipeInput> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<CuttingBoardRecipe, CuttingBoardRecipeInput>(this, this.inventory.player.level()){

            @Override
            public RecipeType<CuttingBoardRecipe> getRecipeType() {
                return (RecipeType)ModRecipeTypes.CUTTING.get();
            }

            @Override
            @NotNull
            public CuttingBoardRecipeInput getInput(Container container, RecipeHolder<CuttingBoardRecipe> recipe) {
                return new CuttingBoardRecipeInput(container.getItem(0), this.findTool(recipe));
            }

            private ItemStack findTool(RecipeHolder<CuttingBoardRecipe> recipe) {
                if (recipe == null) {
                    return ItemStack.EMPTY;
                }
                ItemStack[] tools = ((CuttingBoardRecipe)recipe.value()).getTool().getItems();
                return tools.length == 0 ? ItemStack.EMPTY : tools[0];
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull HolderLookup.Provider provider, @NotNull RecipeHolder<CuttingBoardRecipe> recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(provider, recipe, payload);
        this.inputContainer.setItem(0, ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)payload.getCompound("input")));
    }

    @Override
    protected void onRecipeChanged(HolderLookup.Provider provider, CuttingBoardRecipeInput input) {
        int prevSlots = this.resultSlots.size();
        this.results.clear();
        if (this.recipe != null) {
            this.results.addAll((Collection<ChanceResult>)((CuttingBoardRecipe)((RecipeHolder)this.recipe).value()).getRollableResults());
        }
        int addingSlots = this.results.size() - prevSlots;
        for (int i = 0; i < addingSlots; ++i) {
            int index = prevSlots + i;
            int xi = index % 5;
            int yi = index / 5;
            int x = 73 + xi * 18;
            int y = 18 + yi * 18;
            this.resultSlots.add(this.addSlot(new TeachResultSlot(this, this.resultContainer, index, x, y){

                public boolean isActive() {
                    return !this.getItem().isEmpty();
                }
            }));
        }
    }

    @Override
    @Nullable
    public Component getRecipeError(@NotNull RecipeHolder<CuttingBoardRecipe> recipe) {
        if (!IngredientHelper.isTool(((CuttingBoardRecipe)recipe.value()).getTool(), this.getToolType())) {
            return Component.translatable((String)"minecolonies_compatibility.text.unsupported_tool");
        }
        boolean anyPrimary = ((CuttingBoardRecipe)recipe.value()).getRollableResults().stream().anyMatch(r -> (double)r.chance() >= 1.0);
        if (!anyPrimary) {
            return Component.translatable((String)"minecolonies_compatibility.text.no_primary_result_item");
        }
        return super.getRecipeError(recipe);
    }

    public EquipmentTypeEntry getToolType() {
        return this.toolType;
    }

    public List<ChanceResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }
}

