/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.crafting.ISecondaryRollableRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingChanceResult;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingGenericRecipe;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public class CuttingRecipeStorage
extends GenericedRecipeStorage<CuttingGenericRecipe>
implements ISecondaryRollableRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("farmerdelight_cutting");
    private final ResourceLocation recipeId;
    private final List<ItemStorage> ingredients;
    private final List<CuttingChanceResult> results;
    private final EquipmentTypeEntry toolType;
    private final CuttingGenericRecipe genericRecipe;

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag, CuttingRecipeStorage recipe) {
        tag.putString("recipeId", recipe.recipeId.toString());
        NBTUtils2.serializeCollection(tag, "ingredients", recipe.ingredients, SerializationHelper.serializerTag((HolderLookup.Provider)provider));
        NBTUtils2.serializeCollection(tag, "results", recipe.results, SerializationHelper.apply((HolderLookup.Provider)provider, CuttingChanceResult::serialize));
        tag.putString("toolType", recipe.toolType.getRegistryName().toString());
    }

    public static CuttingRecipeStorage deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        ResourceLocation recipeId = ResourceLocation.parse((String)tag.getString("recipeId"));
        List<ItemStorage> ingredients = NBTUtils2.deserializeList(tag, "ingredients", SerializationHelper.deserializerTag((HolderLookup.Provider)provider));
        List<CuttingChanceResult> results = NBTUtils2.deserializeList(tag, "results", SerializationHelper.apply((HolderLookup.Provider)provider, CuttingChanceResult::deserialize));
        EquipmentTypeEntry toolType = (EquipmentTypeEntry)IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry().get(ResourceLocation.parse((String)tag.getString("toolType")));
        return new CuttingRecipeStorage(recipeId, ingredients, results, toolType);
    }

    public CuttingRecipeStorage(ResourceLocation recipeId, List<ItemStorage> ingredients, List<CuttingChanceResult> results, EquipmentTypeEntry toolType) {
        this.recipeId = recipeId;
        this.ingredients = ItemStorageHelper.filterNotEmpty(ingredients);
        this.results = ImmutableList.copyOf(results);
        this.toolType = toolType;
        this.genericRecipe = new CuttingGenericRecipe(recipeId, ItemStorageHelper.getStacksLists(ingredients), results, toolType);
    }

    @Override
    @NotNull
    public List<ItemStack> rollSecondaryOutputs(@NotNull LootParams context) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (CuttingChanceResult result : this.genericRecipe.getAdditionalResults()) {
            double roll = context.getLevel().getRandom().nextDouble();
            if (!(roll <= (double)result.getChance())) continue;
            list.add(result.getStack());
        }
        return list;
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.ingredients, this.results, this.toolType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CuttingRecipeStorage) {
            CuttingRecipeStorage other = (CuttingRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.ingredients.equals(other.ingredients) && this.results.equals(other.results) && this.toolType.equals(other.toolType);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public List<ItemStorage> getInput() {
        return this.ingredients;
    }

    public List<CuttingChanceResult> getResults() {
        return this.results;
    }

    @Override
    @NotNull
    public CuttingGenericRecipe getGenericRecipe() {
        return this.genericRecipe;
    }
}

