/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;

public class CuttingChanceResult {
    private final ItemStack stack;
    private final float chance;

    public static CuttingChanceResult deserialize(HolderLookup.Provider provider, CompoundTag tag) {
        ItemStack stack = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("stack"));
        float chance = tag.getFloat("chance");
        return new CuttingChanceResult(stack, chance);
    }

    public static CompoundTag serialize(HolderLookup.Provider provider, CuttingChanceResult result) {
        CompoundTag tag = new CompoundTag();
        tag.put("stack", (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)result.stack));
        tag.putFloat("chance", result.chance);
        return tag;
    }

    public CuttingChanceResult(ChanceResult original) {
        this.stack = original.stack();
        this.chance = original.chance();
    }

    public CuttingChanceResult(ItemStack stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public int hashCode() {
        return Objects.hash(this.stack.getItem(), Float.valueOf(this.chance));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof CuttingChanceResult) {
            CuttingChanceResult other = (CuttingChanceResult)obj;
            return ItemStackHelper.equals(this.stack, other.stack) && this.chance == other.chance;
        }
        return false;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }
}

