/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.butchercraft.butcherable;

import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherBlockContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherCitizenContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedButcherable;
import steve_gall.minecolonies_compatibility.api.common.crafting.ToolOrIngredientStack;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.butcher.EntityAIWorkButcher;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.init.ModuleBuildingModules;

public abstract class AbstractButcherable
extends CustomizedButcherable {
    private static List<ItemStack> FIXEDS;

    @NotNull
    protected List<ToolOrIngredientStack> getToolIcons(@NotNull List<AnimatedRecipeItemUse> itemUses) {
        HashSet<IntList> stackingIdsSet = new HashSet<IntList>();
        ArrayList<ToolOrIngredientStack> toolIcons = new ArrayList<ToolOrIngredientStack>();
        for (AnimatedRecipeItemUse itemUse : itemUses) {
            if (!stackingIdsSet.add(itemUse.tool().getStackingIds())) continue;
            toolIcons.add(this.getTool(itemUse));
        }
        return Collections.unmodifiableList(toolIcons);
    }

    @NotNull
    protected ToolOrIngredientStack getTool(@NotNull AnimatedRecipeItemUse itemUse) {
        int count;
        Ingredient tool = itemUse.tool();
        int n = count = IngredientHelper.isDamageable(tool) ? itemUse.count() : itemUse.count() * itemUse.uses();
        if (FIXEDS == null) {
            ArrayList list = new ArrayList();
            list.add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            list.add(new ItemStack((ItemLike)Items.BUCKET));
            list.add(new ItemStack((ItemLike)ButchercraftItems.BUTCHER_KNIFE.get()));
            list.add(new ItemStack((ItemLike)ButchercraftItems.SKINNING_KNIFE.get()));
            list.add(new ItemStack((ItemLike)ButchercraftItems.BONE_SAW.get()));
            list.add(new ItemStack((ItemLike)ButchercraftItems.GUT_KNIFE.get()));
            FIXEDS = Collections.unmodifiableList(list);
        }
        for (ItemStack fix : FIXEDS) {
            if (!tool.test(fix)) continue;
            return ToolOrIngredientStack.of(tool, count);
        }
        EquipmentTypeEntry toolType = IngredientHelper.findFirstToolType(tool);
        return toolType == ModEquipmentTypes.none.get() ? ToolOrIngredientStack.of(tool, count) : ToolOrIngredientStack.of(toolType);
    }

    protected boolean isSkippable(@NotNull Predicate<ItemStack> predicate) {
        return predicate.test(new ItemStack((ItemLike)Items.GLASS_BOTTLE)) || predicate.test(new ItemStack((ItemLike)Items.BUCKET));
    }

    protected boolean trySkip(@NotNull Predicate<ItemStack> predicate, @NotNull EntityAIWorkButcher ai) {
        return ((BoolSetting)ai.building.getSetting(ModuleBuildingModules.SKIP_BLOOD)).getValue() != false && this.isSkippable(predicate);
    }

    @Override
    @NotNull
    public ToolOrIngredientStack getTableTool(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        return ToolOrIngredientStack.EMPTY;
    }
}

