/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.atmospheric;

import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class YuccaFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return AtmosphericItems.YUCCA_FRUIT.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)AtmosphericBlocks.YUCCA_BRANCH.get()), new ItemStack((ItemLike)AtmosphericBlocks.YUCCA_BUNDLE.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)AtmosphericItems.YUCCA_FRUIT.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        if (state.is((Block)AtmosphericBlocks.YUCCA_BUNDLE.get())) {
            BlockState above = context.getLevel().getBlockState(context.getPosition().above());
            return above.is((Block)AtmosphericBlocks.YUCCA_BRANCH.get());
        }
        if (state.is((Block)AtmosphericBlocks.YUCCA_BRANCH.get())) {
            BlockState below = context.getLevel().getBlockState(context.getPosition().below());
            return below.isAir();
        }
        return false;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return context.getState().is((Block)AtmosphericBlocks.YUCCA_BUNDLE.get());
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    public EquipmentTypeEntry getHarvestToolType() {
        return (EquipmentTypeEntry)ModEquipmentTypes.axe.get();
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            level.setBlockAndUpdate(context.getPosition(), Blocks.AIR.defaultBlockState());
        }
        return context.getDrops(harvester);
    }
}

