/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.atmospheric;

import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class DragonFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return AtmosphericItems.DRAGON_FRUIT.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)AtmosphericBlocks.DRAGON_ROOTS.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)AtmosphericItems.DRAGON_FRUIT.get()), new ItemStack((ItemLike)AtmosphericItems.ENDER_DRAGON_FRUIT.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == AtmosphericBlocks.DRAGON_ROOTS.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return DragonRootsBlock.hasFruit((BlockState)context.getState());
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            BlockState state;
            ServerLevel level = (ServerLevel)levelReader;
            BlockState newState = state = context.getState();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (EnumProperty property : Arrays.asList(DragonRootsBlock.TOP_STAGE, DragonRootsBlock.BOTTOM_STAGE)) {
                if (!DragonRootsBlock.hasFruit((EnumProperty)property, (BlockState)state)) continue;
                newState = (BlockState)newState.setValue((Property)property, (Comparable)DragonRootsStage.ROOTS);
                list.add(new ItemStack(DragonRootsBlock.isEnder((EnumProperty)property, (BlockState)state) ? (ItemLike)AtmosphericItems.ENDER_DRAGON_FRUIT.get() : (ItemLike)AtmosphericItems.DRAGON_FRUIT.get()));
            }
            level.setBlock(context.getPosition(), newState, 2);
            return list;
        }
        return Collections.emptyList();
    }
}

