/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.client.jei;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.core.compatibility.jei.RenderHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherableIconCache;
import steve_gall.minecolonies_compatibility.api.common.crafting.ToolOrIngredientStack;
import steve_gall.minecolonies_compatibility.core.common.init.ModItems;

public class ButcherCategory
extends JobBasedRecipeCategory<ButcherableIconCache> {
    protected static final int TOOL_X = 149;
    protected static final int TOOL_Y = 26;
    protected static final int BLOCK_X = 65;
    protected static final int BLOCK_Y = 42;
    protected static final int BLOCK_X2 = 53;
    protected static final int BLOCK_Y2 = 34;
    protected static final int ARROW_WIDTH = 24;
    protected static final int ARROW_HEIGHT = 18;
    protected static final int ARROW_X = 53;
    protected static final int ARROW_Y = 60;
    protected static final int INPUT_X = 81;
    protected static final int INPUT_Y = 60;
    protected static final int OUTPUT_X = 57;
    protected static final int OUTPUT_Y = 83;
    private final IDrawableStatic arrow;

    public ButcherCategory(@NotNull IJob<?> job, @NotNull RecipeType<ButcherableIconCache> type, @NotNull IGuiHelper guiHelper) {
        super(job, type, new ItemStack((ItemLike)ModItems.BUTCHERABLE_ICON.get()), guiHelper);
        this.arrow = guiHelper.createDrawable(TEXTURE, 20, 121, 24, 18);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ButcherableIconCache recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder slot;
        IRecipeSlotBuilder inputSLot = builder.addSlot(RecipeIngredientRole.INPUT, 81, 60);
        inputSLot.addItemStacks(recipe.getItemIcons());
        List<Ingredient> outputs = recipe.getOutputIcons();
        IRecipeSlotBuilder[] slots = new IRecipeSlotBuilder[12];
        int cols = 6;
        for (int i = 0; i < slots.length; ++i) {
            int xi = i % cols;
            int yi = i / cols;
            slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 57 + xi * 18, 83 + yi * 18);
            slot.setBackground((IDrawable)this.slot, -1, -1);
            slots[i] = slot;
        }
        int index = 0;
        int packedSize = (outputs.size() + slots.length - 1) / slots.length * slots.length;
        for (int i = 0; i < packedSize; ++i) {
            slot = slots[index++ % slots.length];
            if (i < outputs.size()) {
                slot.addIngredients(outputs.get(i));
                continue;
            }
            slot.addItemStack(ItemStack.EMPTY);
        }
        ArrayList<ToolOrIngredientStack> tools = new ArrayList<ToolOrIngredientStack>(recipe.getButcherable().getToolsForIcon());
        tools.removeIf(ToolOrIngredientStack::isEmpty);
        for (int i = 0; i < tools.size(); ++i) {
            ToolOrIngredientStack ingredient = tools.get(i);
            int x = 149 - (tools.size() - i - 1) * 18;
            int y = 26;
            if (ingredient.isToolType()) {
                this.addToolSlot(builder, ingredient.toolType(), x, y, true);
                continue;
            }
            IRecipeSlotBuilder slot2 = builder.addSlot(RecipeIngredientRole.CATALYST, x, y);
            slot2.setBackground((IDrawable)this.slot, -1, -1);
            slot2.addIngredients(ingredient.stack().ingredient());
        }
    }

    public void draw(ButcherableIconCache recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        this.arrow.draw(graphics, 53, 60);
        List<BlockState> tableIcons = recipe.getTableIcons();
        for (int i = 0; i < tableIcons.size(); ++i) {
            RenderHelper.renderBlock((GuiGraphics)graphics, (BlockState)tableIcons.get(i), (float)(65 + i * 32), (float)42.0f, (float)100.0f, (float)-30.0f, (float)30.0f, (float)16.0f);
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull ButcherableIconCache recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        List tooltips = super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
        List<BlockState> tableIcons = recipe.getTableIcons();
        for (int i = 0; i < tableIcons.size(); ++i) {
            if (!new Rect2i(53 + i * 32, 34, 24, 24).contains((int)mouseX, (int)mouseY)) continue;
            tooltips.add(Component.translatable((String)"com.minecolonies.coremod.jei.intermediate.tip", (Object[])new Object[]{tableIcons.get(i).getBlock().getName()}));
        }
        return tooltips;
    }

    @NotNull
    protected List<Component> generateInfoBlocks(@NotNull ButcherableIconCache recipe) {
        return Collections.emptyList();
    }
}

