/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.client.farmersdelight;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import steve_gall.minecolonies_compatibility.core.client.gui.TeachCraftingRecipeScreen;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.FarmersDelightModule;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingChanceResult;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleCraftingTypes;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.menu.CuttingTeachMenu;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;

public class CuttingTeachScreen
extends TeachCraftingRecipeScreen<CuttingTeachMenu, RecipeHolder<CuttingBoardRecipe>> {
    public static final ResourceLocation TEXTURE = MineColoniesCompatibility.rl("textures/gui/farmers_cutting_teach.png");

    public CuttingTeachScreen(CuttingTeachMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public CraftingType getCraftingType() {
        return (CraftingType)ModuleCraftingTypes.CUTTING.get();
    }

    @Override
    protected ICustomizedRecipeStorage createRecipeStorage(RecipeHolder<CuttingBoardRecipe> recipe, List<ItemStorage> input) {
        List<CuttingChanceResult> results = ((CuttingTeachMenu)this.menu).getResults().stream().map(CuttingChanceResult::new).toList();
        return new CuttingRecipeStorage(recipe.id(), input, results, ((CuttingTeachMenu)this.menu).getToolType());
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((CuttingTeachMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ItemStack item = this.hoveredSlot.getItem();
            List tooltip = CuttingTeachScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)item);
            Optional tooltipImage = item.getTooltipImage();
            int resultIndex = ((CuttingTeachMenu)this.menu).getResultSlots().indexOf(this.hoveredSlot);
            if (resultIndex > -1) {
                tooltip.addAll(1, FarmersDelightModule.getChanceTooltip(((CuttingTeachMenu)this.menu).getResults().get(resultIndex).chance()));
            }
            graphics.renderTooltip(this.font, tooltip, tooltipImage, mouseX, mouseY);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        List<ChanceResult> results = ((CuttingTeachMenu)this.menu).getResults();
        List<Slot> resultSlots = ((CuttingTeachMenu)this.menu).getResultSlots();
        for (int i = 0; i < results.size(); ++i) {
            Slot slot = resultSlots.get(i);
            boolean alt = results.get(i).chance() < 1.0f;
            graphics.blit(TEXTURE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, this.imageWidth + (alt ? 18 : 0), 0, 18, 18);
        }
    }

    @Override
    public int getSwitchButtonX() {
        return 44;
    }

    @Override
    public int getSwitchButtonY() {
        return 16;
    }
}

