/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.entity.ai.workers.util.GuardGear;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIFight;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import steve_gall.minecolonies_compatibility.api.common.tool.CustomizedToolSystem;

@Mixin(value={AbstractEntityAIFight.class}, remap=false)
public abstract class AbstractEntityAIFightMixin<J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AbstractEntityAIInteract<J, B> {
    @Shadow(remap=false)
    private List<List<GuardGear>> itemsNeeded;

    public AbstractEntityAIFightMixin(@NotNull J job) {
        super(job);
    }

    @Inject(method={"atBuildingActions"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    private void atBuildingActions(CallbackInfo ci) {
        this.dumpBrokenArmors();
    }

    @Inject(method={"equipInventoryArmor"}, remap=false, at={@At(value="HEAD")}, cancellable=false)
    private void equipInventoryArmor(CallbackInfo ci) {
        this.dumpBrokenArmors();
    }

    private void dumpBrokenArmors() {
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        for (EquipmentSlot slot : Arrays.asList(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.LEGS)) {
            ItemStack armor = inventory.getArmorInSlot(slot);
            CustomizedToolSystem system = CustomizedToolSystem.select(armor);
            if (system == null || !system.isBroken(armor)) continue;
            if (InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((ItemStack)armor, (IItemHandler)this.getBuildingToDump().getItemHandlerCap())) {
                inventory.forceClearArmorInSlot(slot, armor);
                continue;
            }
            inventory.moveArmorToInventory(slot);
        }
    }
}

