/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import com.minecolonies.api.inventory.container.ContainerCrafting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;
import steve_gall.minecolonies_compatibility.module.common.polymorph.PolymorphModule;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class TeachRecipeMenuSelectMessage
extends AbstractMessage {
    public static final CustomPacketPayload.Type<TeachRecipeMenuSelectMessage> TYPE = new CustomPacketPayload.Type(MineColoniesCompatibility.rl("teach_recipe_menu_select"));
    private final ResourceLocation recipeId;

    public TeachRecipeMenuSelectMessage(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public TeachRecipeMenuSelectMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.recipeId = buffer.readResourceLocation();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeResourceLocation(this.recipeId);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        Player player = context.player();
        RegistryAccess registryAccess = player.level().registryAccess();
        RecipeHolder holder = player.level().getRecipeManager().byKey(this.recipeId).orElse(null);
        if (holder == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ContainerCrafting) {
            ContainerCrafting menu = (ContainerCrafting)abstractContainerMenu;
            CraftingInput input = menu.craftMatrix.asCraftInput();
            ItemStack output = ((CraftingRecipe)holder.value()).assemble((RecipeInput)input, (HolderLookup.Provider)registryAccess);
            menu.craftResult.setItem(0, output);
            if (ModuleManager.POLYMORPH.isLoaded()) {
                PolymorphModule.sendRecipesList((ServerPlayer)player, input, output);
            }
        } else {
            abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof TeachRecipeMenu) {
                TeachRecipeMenu menu = (TeachRecipeMenu)abstractContainerMenu;
                menu.setRecipeIndex(menu.getRecipes().indexOf(holder));
            }
        }
    }

    public CustomPacketPayload.Type<TeachRecipeMenuSelectMessage> type() {
        return TYPE;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }
}

