/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class TeachRecipeMenuNewResultMessage
extends AbstractMessage {
    public static final CustomPacketPayload.Type<TeachRecipeMenuNewResultMessage> TYPE = new CustomPacketPayload.Type(MineColoniesCompatibility.rl("teach_recipe_menu_new_result"));
    @Nullable
    private final CompoundTag tag;

    public TeachRecipeMenuNewResultMessage(@Nullable CompoundTag tag) {
        this.tag = tag;
    }

    public TeachRecipeMenuNewResultMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.tag = (CompoundTag)buffer.readNullable(FriendlyByteBuf::readNbt);
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeNullable((Object)this.tag, FriendlyByteBuf::writeNbt);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        Minecraft mc = Minecraft.getInstance();
        AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
        if (abstractContainerMenu instanceof TeachRecipeMenu) {
            TeachRecipeMenu menu = (TeachRecipeMenu)abstractContainerMenu;
            menu.onNewResultTransfer(this.tag);
        }
    }

    public CustomPacketPayload.Type<TeachRecipeMenuNewResultMessage> type() {
        return TYPE;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }
}

