/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class TeachRecipeMenuNewRecipesMessage
extends AbstractMessage {
    public static final CustomPacketPayload.Type<TeachRecipeMenuNewRecipesMessage> TYPE = new CustomPacketPayload.Type(MineColoniesCompatibility.rl("teach_recipe_menu_new_recipes"));
    private final List<CompoundTag> recipes;

    public TeachRecipeMenuNewRecipesMessage(List<CompoundTag> recipes) {
        this.recipes = ImmutableList.copyOf(recipes);
    }

    public TeachRecipeMenuNewRecipesMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.recipes = buffer.readList(FriendlyByteBuf::readNbt);
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeCollection(this.recipes, FriendlyByteBuf::writeNbt);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        Minecraft mc = Minecraft.getInstance();
        AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
        if (abstractContainerMenu instanceof TeachRecipeMenu) {
            TeachRecipeMenu menu = (TeachRecipeMenu)abstractContainerMenu;
            RegistryAccess registryAccess = menu.getInventory().player.registryAccess();
            List<Object> recipes = this.recipes.stream().map(r -> menu.getRecipeValidator().deserialize((HolderLookup.Provider)registryAccess, (IFactoryController)StandardFactoryController.getInstance(), (CompoundTag)r)).toList();
            menu.onNewRecipesTransfer(recipes);
        }
    }

    public CustomPacketPayload.Type<TeachRecipeMenuNewRecipesMessage> type() {
        return TYPE;
    }

    public List<CompoundTag> getRecipes() {
        return this.recipes;
    }
}

