/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_compatibility.api.common.inventory.IFluidGhostMenu;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.core.common.fluid.FluidSerializationHelper;

public class JEIGhostAcceptFluidMessage
extends AbstractMessage {
    public static final CustomPacketPayload.Type<JEIGhostAcceptFluidMessage> TYPE = new CustomPacketPayload.Type(MineColoniesCompatibility.rl("jei_ghost_accept_fluid"));
    private final int slotNumber;
    private final FluidStack stack;

    public JEIGhostAcceptFluidMessage(int slotNumber, FluidStack stack) {
        this.slotNumber = slotNumber;
        this.stack = stack;
    }

    public JEIGhostAcceptFluidMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.slotNumber = buffer.readInt();
        this.stack = FluidSerializationHelper.deserialize((FriendlyByteBuf)buffer);
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.slotNumber);
        FluidSerializationHelper.serialize((FriendlyByteBuf)buffer, (FluidStack)this.stack);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        Player player = context.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IFluidGhostMenu) {
            IFluidGhostMenu ghostMenu = (IFluidGhostMenu)abstractContainerMenu;
            ghostMenu.onGhostAcceptFluid(this.slotNumber, this.stack);
        }
    }

    public CustomPacketPayload.Type<JEIGhostAcceptFluidMessage> type() {
        return TYPE;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public FluidStack getStack() {
        return this.stack;
    }
}

