/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.job;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.constant.CitizenConstants;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.util.AttributeModifierUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.EntityAIWorkOrchardist;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.Fruit;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.OrchardistConfig;

public class JobOrchardist
extends AbstractJob<EntityAIWorkOrchardist, JobOrchardist> {
    public static final String TAG_FRUIT = "Fruit";
    @Nullable
    private Fruit fruit;

    public JobOrchardist(ICitizenData entity) {
        super(entity);
    }

    public void onLevelUp() {
        this.getCitizen().getEntity().ifPresent(this::onLevelUp);
    }

    private void onLevelUp(AbstractEntityCitizen worker) {
        ICitizenData citizen = this.getCitizen();
        OrchardistConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.orchardist;
        WorkerBuildingModule module = (WorkerBuildingModule)this.getWorkModule();
        double amount = (double)citizen.getCitizenSkillHandler().getLevel(module.getSecondarySkill()) * (Double)config.moveSpeedBonusPerSkillLevel.get();
        AttributeModifier speedModifier = new AttributeModifier(CitizenConstants.SKILL_BONUS_ADD_NAME, amount, AttributeModifier.Operation.ADD_VALUE);
        AttributeModifierUtils.addModifier((LivingEntity)worker, (AttributeModifier)speedModifier, (Holder)Attributes.MOVEMENT_SPEED);
    }

    public void onRemoval() {
        this.getCitizen().getEntity().ifPresent(this::onRemoval);
        super.onRemoval();
    }

    private void onRemoval(AbstractEntityCitizen worker) {
        AttributeModifierUtils.removeModifier((LivingEntity)worker, (ResourceLocation)CitizenConstants.SKILL_BONUS_ADD_NAME, (Holder)Attributes.MOVEMENT_SPEED);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        if (this.fruit != null) {
            CompoundTag fruitTag = new CompoundTag();
            this.fruit.serialize(fruitTag);
            compound.put(TAG_FRUIT, (Tag)fruitTag);
        }
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        if (compound.contains(TAG_FRUIT)) {
            this.fruit = Fruit.deserialize(compound.getCompound(TAG_FRUIT));
        }
    }

    public EntityAIWorkOrchardist generateAI() {
        return new EntityAIWorkOrchardist(this);
    }

    public ResourceLocation getModel() {
        return ModModelTypes.LUMBERJACK_ID;
    }

    @Nullable
    public Fruit getFruit() {
        return this.fruit;
    }

    public void setFruit(@Nullable Fruit fruit) {
        this.fruit = fruit;
    }
}

