/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.inventory.IItemGhostMenu;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.IRecipeTransferableMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.ModuleMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuNewRecipesMessage;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuNewResultMessage;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;
import steve_gall.minecolonies_compatibility.module.common.polymorph.PolymorphModule;

public abstract class TeachRecipeMenu<RECIPE, RECIPE_INPUT>
extends ModuleMenu
implements IItemGhostMenu,
IRecipeTransferableMenu<RECIPE, RECIPE_INPUT> {
    public static final Component TEXT_RECIPE_NOT_FOUND = Component.translatable((String)"minecolonies_compatibility.text.recipe_not_found");
    public static final Component TEXT_RECIPE_NOT_SUPPORTED = Component.translatable((String)"minecolonies_compatibility.text.recipe_not_supported");
    protected TeachContainer inputContainer;
    protected List<Slot> inputSlots;
    protected Container resultContainer;
    protected List<Slot> resultSlots;
    private IMenuRecipeValidator<RECIPE, RECIPE_INPUT> recipeValidator;
    private List<RECIPE> recipes;
    private int recipeIndex = -1;
    protected RECIPE recipe;

    public TeachRecipeMenu(MenuType<?> menuType, int windowId, Inventory inventory, IBuildingModule module) {
        super(menuType, windowId, inventory, module);
        this.setup();
    }

    public TeachRecipeMenu(MenuType<?> menuType, int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super(menuType, windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.inputSlots = new ArrayList<Slot>();
        this.resultSlots = new ArrayList<Slot>();
        this.inputContainer = null;
        this.resultContainer = null;
        this.recipeValidator = null;
        this.recipes = Collections.emptyList();
        this.recipeIndex = -1;
        this.recipe = null;
    }

    protected abstract IMenuRecipeValidator<RECIPE, RECIPE_INPUT> createRecipeValidator();

    protected abstract void onRecipeChanged(@NotNull HolderLookup.Provider var1, @Nullable RECIPE_INPUT var2);

    @Override
    public IMenuRecipeValidator<RECIPE, RECIPE_INPUT> getRecipeValidator() {
        if (this.recipeValidator == null) {
            this.recipeValidator = this.createRecipeValidator();
        }
        return this.recipeValidator;
    }

    @Override
    public final void onRecipeTransfer(@NotNull RECIPE recipe, @NotNull CompoundTag payload) {
        RegistryAccess registryAccess = this.inventory.player.registryAccess();
        this.setContainerByTransfer((HolderLookup.Provider)registryAccess, recipe, payload);
        this.refreshRecipes(recipe);
    }

    protected void setContainerByTransfer(@NotNull HolderLookup.Provider provider, @NotNull RECIPE recipe, @NotNull CompoundTag payload) {
        this.inputContainer.clearContent();
    }

    @Override
    public void onGhostAcceptItem(int slotNumber, ItemStack stack, boolean isVirtual) {
        if (!isVirtual) {
            Slot slot = (Slot)this.slots.get(slotNumber);
            this.handleSlotClick(slot, stack);
        }
    }

    public void slotsChanged(Container container) {
        this.onSlotsChanged(container);
        super.slotsChanged(container);
    }

    protected void onSlotsChanged(Container container) {
        if (container == this.inputContainer) {
            this.refreshRecipes(null);
        }
    }

    protected void refreshRecipes(RECIPE show) {
        Player player = this.inventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            IMenuRecipeValidator recipeValidator = this.getRecipeValidator();
            this.recipes = new ArrayList<RECIPE>(recipeValidator.findAll(this.inputContainer, player2));
            List<CompoundTag> tags = this.recipes.stream().map(r -> recipeValidator.serialize((HolderLookup.Provider)player2.registryAccess(), (IFactoryController)StandardFactoryController.getInstance(), r)).toList();
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new TeachRecipeMenuNewRecipesMessage(tags), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (ModuleManager.POLYMORPH.isLoaded()) {
                PolymorphModule.sendRecipesList(player2, this);
            }
            this.setRecipeIndex(show == null ? 0 : this.recipes.indexOf(show));
        }
    }

    public final void onNewRecipesTransfer(List<RECIPE> recipes) {
        this.recipes = new ArrayList<RECIPE>(recipes);
        this.setRecipeIndex(-1);
    }

    protected void setRecipe(RECIPE recipe) {
        this.recipe = recipe;
        this.onRecipeChanged((HolderLookup.Provider)this.inventory.player.registryAccess(), this.getRecipeInput(recipe));
        Player player = this.inventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag tag = recipe != null ? this.getRecipeValidator().serialize((HolderLookup.Provider)player2.registryAccess(), (IFactoryController)StandardFactoryController.getInstance(), recipe) : null;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new TeachRecipeMenuNewResultMessage(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (ModuleManager.POLYMORPH.isLoaded() && recipe instanceof RecipeHolder) {
                PolymorphModule.sendRecipesList(player2, this);
            }
        }
    }

    public final void onNewResultTransfer(CompoundTag tag) {
        if (tag != null) {
            RECIPE recipe = this.getRecipeValidator().deserialize((HolderLookup.Provider)this.inventory.player.registryAccess(), (IFactoryController)StandardFactoryController.getInstance(), tag);
            this.setRecipe(recipe);
        } else {
            this.setRecipe(null);
        }
    }

    @Nullable
    public Component getCurrentError() {
        return this.recipe != null ? this.getRecipeError(this.recipe) : TEXT_RECIPE_NOT_FOUND;
    }

    @Nullable
    public Component getRecipeError(@NotNull RECIPE recipe) {
        return null;
    }

    public void clicked(int slotNumber, int clickedButton, ClickType mode, Player player) {
        if (0 <= slotNumber && slotNumber < this.slots.size()) {
            Slot slot = (Slot)this.slots.get(slotNumber);
            if (slot.container == this.inputContainer || slot.container == this.resultContainer) {
                if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                    this.handleSlotClick(slot, this.getCarried());
                }
                return;
            }
            if (mode == ClickType.QUICK_MOVE) {
                return;
            }
        }
        super.clicked(slotNumber, clickedButton, mode, player);
    }

    public void handleSlotClick(Slot slot, ItemStack stack) {
        if (slot.container == this.inputContainer) {
            this.setSlot(slot, stack);
        }
    }

    protected void setSlot(Slot slot, ItemStack stack) {
        if (stack.getCount() > 0) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            slot.set(copy);
        } else if (slot.getItem().getCount() > 0) {
            slot.set(ItemStack.EMPTY);
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return !this.resultSlots.contains(slot) && super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public RECIPE_INPUT getRecipeInput(RECIPE recipe) {
        return this.getRecipeValidator().getInput(this.inputContainer, recipe);
    }

    public TeachContainer getInputContainer() {
        return this.inputContainer;
    }

    public List<Slot> getCraftSlots() {
        return Collections.unmodifiableList(this.inputSlots);
    }

    public Container getResultContainer() {
        return this.resultContainer;
    }

    public List<Slot> getResultSlots() {
        return Collections.unmodifiableList(this.resultSlots);
    }

    public RECIPE getRecipe() {
        return this.recipe;
    }

    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    public void setRecipeIndex(int index) {
        if (0 <= index && index < this.getRecipes().size()) {
            this.recipeIndex = index;
            this.setRecipe(this.recipes.get(index));
        } else {
            this.recipeIndex = -1;
            this.setRecipe(null);
        }
    }

    public List<RECIPE> getRecipes() {
        return this.recipes;
    }
}

