/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ReadOnlySlotsContainer
implements Container {
    private final IntSupplier sizeSupplier;
    private final IntFunction<ItemStack> stackFunction;

    public ReadOnlySlotsContainer(IntSupplier sizeSupplier, IntFunction<ItemStack> stackFunction) {
        this.sizeSupplier = sizeSupplier;
        this.stackFunction = stackFunction;
    }

    public void clearContent() {
    }

    public int getContainerSize() {
        return this.sizeSupplier.getAsInt();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot < this.getContainerSize() ? this.stackFunction.apply(slot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int count) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return false;
    }
}

