/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import steve_gall.minecolonies_compatibility.core.common.block.entity.IAccessDirectionHolder;
import steve_gall.minecolonies_compatibility.core.common.init.ModMenuTypes;
import steve_gall.minecolonies_compatibility.core.common.inventory.BaseMenu;

public class AccessDirectionHolderMenu<BLOCK_ENTITY extends BlockEntity & IAccessDirectionHolder>
extends BaseMenu {
    private final BLOCK_ENTITY blockEntity;

    public static <BLOCK_ENTITY extends BlockEntity & IAccessDirectionHolder> void open(Level level, BlockPos pos, Player player) {
        if (level.isClientSide()) {
            return;
        }
        final BlockEntity blockEntity = level.getBlockEntity(pos);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                    return new AccessDirectionHolderMenu<BlockEntity>(windowId, inventory, blockEntity);
                }

                public Component getDisplayName() {
                    return blockEntity.getBlockState().getBlock().getName();
                }
            }, pos);
        }
    }

    public AccessDirectionHolderMenu(int windowId, Inventory inventory, BLOCK_ENTITY blockEntity) {
        super((MenuType)ModMenuTypes.ACCESS_DIRECTION_HOLDER.get(), windowId, inventory);
        this.blockEntity = blockEntity;
        this.setup();
    }

    public AccessDirectionHolderMenu(int windowId, Inventory inventory, FriendlyByteBuf data) {
        super((MenuType)ModMenuTypes.ACCESS_DIRECTION_HOLDER.get(), windowId, inventory);
        BlockPos pos = data.readBlockPos();
        this.blockEntity = inventory.player.level().getBlockEntity(pos);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 55);
    }

    public BLOCK_ENTITY getBlockEntity() {
        return this.blockEntity;
    }

    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player p_38874_) {
        return true;
    }
}

