/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai.fluid_manager;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingDeliveryman;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.building.module.LavaCauldronModule;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.fluid_manager.FluidManagerAIState;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.fluid_manager.FluidManagerConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.pathfinding.MatchBlocksPathResult;
import steve_gall.minecolonies_compatibility.core.common.entity.pathfinding.PathJobFindLavaCauldron;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;
import steve_gall.minecolonies_compatibility.core.common.job.JobFluidManager;

public class EntityAIWorkFluidManager
extends AbstractEntityAICrafting<JobFluidManager, BuildingDeliveryman> {
    public static final VisibleCitizenStatus SEARCH = new VisibleCitizenStatus(ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"textures/icons/work/lumberjack_search.png"), "com.minecolonies.gui.visiblestatus.lumberjack_search");
    public static final double XP_PER_HARVEST = 0.5;
    @Nullable
    private MatchBlocksPathResult pathResult;
    @Nullable
    private BlockPos cauldronPos;
    private long nextSearchDelay = -1L;
    private int pickupProgress = 0;

    public EntityAIWorkFluidManager(@NotNull JobFluidManager job) {
        super((AbstractJobCrafter)job);
        this.registerTargets(new TickingTransition[]{new AITarget((IState)FluidManagerAIState.SEARCH, this::search, 5), new AITarget((IState)FluidManagerAIState.PICKUP, this::pickUp, 5)});
    }

    public void tick() {
        if (this.nextSearchDelay > 0L) {
            this.nextSearchDelay -= 5L;
        }
        super.tick();
    }

    public Class<BuildingDeliveryman> getExpectedBuildingClass() {
        return BuildingDeliveryman.class;
    }

    public boolean hasWorkToDo() {
        return true;
    }

    protected IAIState decide() {
        IAIState state = super.decide();
        if (state != AIWorkerState.IDLE) {
            return state;
        }
        if (this.nextSearchDelay > 0L) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        return this.decideSearch((IAIState)AIWorkerState.START_WORKING);
    }

    protected IAIState decideSearch(IAIState fallback) {
        if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.is(Items.BUCKET)) < 1) {
            this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.BUCKET), 16, 1);
            return fallback;
        }
        return FluidManagerAIState.SEARCH;
    }

    protected IAIState search() {
        if (this.pathResult == null) {
            this.cauldronPos = null;
            this.pickupProgress = 0;
            this.worker.getCitizenData().setVisibleStatus(SEARCH);
            this.pathResult = this.creatNewPath();
            return this.getState();
        }
        if (this.pathResult.isDone()) {
            return this.onPathDone();
        }
        return this.getState();
    }

    protected MatchBlocksPathResult creatNewPath() {
        ServerLevel level = this.world;
        AbstractEntityCitizen worker = this.worker;
        BuildingDeliveryman building = (BuildingDeliveryman)this.building;
        BlockPos start = PathfindingUtils.prepareStart((LivingEntity)worker);
        BlockPos buildingPos = building.getPosition();
        FluidManagerConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.fluidManager;
        PathJobFindLavaCauldron job = null;
        LavaCauldronModule restrictModule = (LavaCauldronModule)building.getModule(ModBuildingModules.FLUID_MANAGER_LAVA_CAULDRON);
        if (restrictModule.isRestrictEnabled()) {
            BoundingBox restrictionBox = BoundingBox.fromCorners((Vec3i)restrictModule.getRestrictAreaPos1(), (Vec3i)restrictModule.getRestrictAreaPos2());
            job = new PathJobFindLavaCauldron((Level)level, start, restrictionBox, (Mob)worker);
        } else {
            int range = (Integer)config.searchRange.get();
            job = new PathJobFindLavaCauldron((Level)level, start, buildingPos, range, (Mob)worker);
        }
        return (MatchBlocksPathResult)((MinecoloniesAdvancedPathNavigate)worker.getNavigation()).setPathJob((AbstractPathJob)job, null, 1.0, true);
    }

    protected IAIState onPathDone() {
        List<BlockPos> positions = this.pathResult.positions;
        this.pathResult = null;
        if (positions.size() == 0) {
            FluidManagerConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.fluidManager;
            this.nextSearchDelay = ((Integer)config.searchDelayAfterNotFound.get()).intValue();
            return AIWorkerState.INVENTORY_FULL;
        }
        this.cauldronPos = positions.get(0);
        return FluidManagerAIState.PICKUP;
    }

    protected IAIState pickUp() {
        if (this.cauldronPos == null || this.world.getBlockState(this.cauldronPos).getBlock() != Blocks.LAVA_CAULDRON) {
            return AIWorkerState.START_WORKING;
        }
        InventoryCitizen inventory = this.getInventory();
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)inventory, stack -> stack.is(Items.BUCKET));
        if (slot == -1) {
            return AIWorkerState.START_WORKING;
        }
        CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.worker, (InteractionHand)InteractionHand.MAIN_HAND, (int)slot);
        if (!this.walkToWorkPos(this.cauldronPos)) {
            return this.getState();
        }
        FluidManagerConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.fluidManager;
        int delay = (Integer)config.pickupDelay.get() - (int)((double)this.getSecondarySkillLevel() * (Double)config.pickupDelayReducePerSkillLevel.get());
        this.hitBlockWithToolInHand(this.cauldronPos);
        new LocalizedParticleEffectMessage(new ItemStack((ItemLike)Items.LAVA_BUCKET), this.cauldronPos).sendToTrackingEntity((Entity)this.worker);
        if (this.pickupProgress < delay) {
            this.pickupProgress += 5;
            return this.getState();
        }
        this.world.setBlock(this.cauldronPos, Blocks.CAULDRON.defaultBlockState(), 3);
        this.world.playSound(null, this.cauldronPos, SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.BLOCKS, 1.0f, 1.0f);
        inventory.getStackInSlot(slot).shrink(1);
        InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((ItemStack)new ItemStack((ItemLike)Items.LAVA_BUCKET), (IItemHandler)inventory);
        CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.worker, (InteractionHand)InteractionHand.MAIN_HAND, (int)slot);
        this.worker.getCitizenExperienceHandler().addExperience(0.5);
        this.incrementActionsDoneAndDecSaturation();
        return this.decideSearch((IAIState)AIWorkerState.INVENTORY_FULL);
    }
}

