/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai.butcher;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.IStateSupplier;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.network.messages.client.BlockParticleEffectMessage;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.io.Serializable;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherBlockContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherCitizenContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedButcherable;
import steve_gall.minecolonies_compatibility.api.common.crafting.IngredientStack;
import steve_gall.minecolonies_compatibility.api.common.crafting.ToolOrIngredientStack;
import steve_gall.minecolonies_compatibility.api.common.requestsystem.IngredientDeliverable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.building.module.ButcherableListModule;
import steve_gall.minecolonies_compatibility.core.common.colony.CitizenHelper;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.butcher.ButcherAIState;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.butcher.ButcherConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.butcher.Butcherable;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.fluid_manager.FluidManagerConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.pathfinding.ButcherPositionsPathResult;
import steve_gall.minecolonies_compatibility.core.common.entity.pathfinding.PathJobFindButcherPosition;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;
import steve_gall.minecolonies_compatibility.core.common.job.JobButcher;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableDeliverable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;

public class EntityAIWorkButcher
extends AbstractEntityAIInteract<JobButcher, AbstractBuilding> {
    public static final double XP_PER_HARVEST = 0.5;
    public static final Component TABLE_NEEDED_KEY = Component.literal((String)MineColoniesCompatibility.tl("butcer.table_needed"));
    @Nullable
    private ButcherPositionsPathResult pathResult;
    private long nextSearchDelay = -1L;
    private BlockPos butcherPosition = null;
    private int butcherProgress = 0;
    private boolean walking = false;

    public EntityAIWorkButcher(@NotNull JobButcher job) {
        super((AbstractJob)job);
        this.registerTargets(new TickingTransition[]{new AITarget((IState)AIWorkerState.IDLE, (IStateSupplier & Serializable)() -> AIWorkerState.START_WORKING, 1), new AITarget((IState)AIWorkerState.START_WORKING, this::decide, 5), new AITarget((IState)ButcherAIState.SEARCH, this::search, 5), new AITarget((IState)ButcherAIState.BUTCHER, this::butcher, 5)});
        this.worker.setCanPickUpLoot(true);
    }

    public void tick() {
        if (this.nextSearchDelay > 0L) {
            this.nextSearchDelay -= 5L;
        }
        super.tick();
    }

    public Class<AbstractBuilding> getExpectedBuildingClass() {
        return AbstractBuilding.class;
    }

    private IAIState decide() {
        int amountInInv;
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        AbstractBuilding building = this.building;
        AbstractEntityCitizen worker = this.worker;
        int amountInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)building, this::testButcherable, (int)1);
        if (amountInBuilding + (amountInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)worker.getInventoryCitizen(), this::testButcherable)) <= 0) {
            ICitizenData citizenData = worker.getCitizenData();
            boolean any = false;
            for (IRequest iRequest : CitizenHelper.getRequests(citizenData, CustomizableDeliverable.TYPE_TOKEN, r -> ((CustomizableDeliverable)r.getRequest()).getObject() instanceof Butcherable)) {
                Butcherable butcherable = (Butcherable)((CustomizableDeliverable)iRequest.getRequest()).getObject();
                if (butcherable.getBlacklist() == null) {
                    citizenData.getColony().getRequestManager().updateRequestState(iRequest.getId(), RequestState.CANCELLED);
                    continue;
                }
                any = true;
            }
            if (!any) {
                ButcherableListModule blacklist = (ButcherableListModule)building.getModule(ModBuildingModules.BUTCHERABLELIST_BLACKLIST);
                citizenData.createRequestAsync((IRequestable)new CustomizableDeliverable((IDeliverableObject)new Butcherable(1, blacklist)));
            }
        } else if (amountInInv <= 0 && amountInBuilding > 0) {
            this.needsCurrently = new Tuple(this::testButcherable, (Object)8);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (this.nextSearchDelay > 0L) {
            return this.getState();
        }
        return ButcherAIState.SEARCH;
    }

    private boolean testButcherable(ItemStack item) {
        return this.selectByItem(item) != null;
    }

    private CustomizedButcherable selectByItem(ItemStack item) {
        CustomizedButcherable butcherable = CustomizedButcherable.selectByItem(item);
        if (butcherable != null && !((ButcherableListModule)this.building.getModule(ModBuildingModules.BUTCHERABLELIST_BLACKLIST)).containsId(butcherable.getId())) {
            return butcherable;
        }
        return null;
    }

    private IAIState search() {
        if (this.pathResult == null) {
            this.pathResult = this.creatNewPath();
            return this.getState();
        }
        if (this.pathResult.isDone()) {
            return this.onPathDone();
        }
        return this.getState();
    }

    @Nullable
    private ButcherPositionsPathResult creatNewPath() {
        AbstractEntityCitizen worker = this.worker;
        BlockPos start = PathfindingUtils.prepareStart((LivingEntity)worker);
        net.minecraft.util.Tuple corners = this.building.getCorners();
        PathJobFindButcherPosition job = new PathJobFindButcherPosition((Level)this.world, start, BoundingBox.fromCorners((Vec3i)((Vec3i)corners.getA()), (Vec3i)((Vec3i)corners.getB())), (Mob)worker);
        job.vertialRange = 2;
        job.exceptButcherables.addAll(((ButcherableListModule)this.building.getModule(ModBuildingModules.BUTCHERABLELIST_BLACKLIST)).getIds());
        return (ButcherPositionsPathResult)((MinecoloniesAdvancedPathNavigate)worker.getNavigation()).setPathJob((AbstractPathJob)job, null, 1.0, true);
    }

    private IAIState onPathDone() {
        Object info;
        ButcherPositionsPathResult result = this.pathResult;
        this.pathResult = null;
        this.butcherProgress = 0;
        this.walking = false;
        ((JobButcher)this.job).setTableNeeded(null);
        Iterator<BlockPos> iterator = result.blocks.iterator();
        if (iterator.hasNext()) {
            BlockPos block;
            this.butcherPosition = block = iterator.next();
            return ButcherAIState.BUTCHER;
        }
        for (BlockPos positon : result.tables) {
            info = this.getButcherTable(positon);
            if (info == null) continue;
            this.butcherPosition = positon;
            return ButcherAIState.BUTCHER;
        }
        for (BlockPos positon : result.tables) {
            info = this.getNeededTable(positon);
            if (info == null) continue;
            ((JobButcher)this.job).setTableNeeded((CustomizedButcherable)info);
            this.worker.getCitizenData().triggerInteraction((IInteractionResponseHandler)new StandardInteraction(((CustomizedButcherable)info).getTableNotFoundMessage(), TABLE_NEEDED_KEY, (IChatPriority)ChatPriority.BLOCKING));
            break;
        }
        FluidManagerConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.fluidManager;
        this.nextSearchDelay = ((Integer)config.searchDelayAfterNotFound.get()).intValue();
        return AIWorkerState.INVENTORY_FULL;
    }

    @Nullable
    private ButcherInfo getButcheringBlock(BlockPos position) {
        ButcherBlockContext context = new ButcherBlockContext((LevelReader)this.world, position, this.world.getBlockState(position));
        CustomizedButcherable butcherable = CustomizedButcherable.selectByButcheringBlock(context);
        if (butcherable != null) {
            return new ButcherInfo(butcherable, true, -1);
        }
        return null;
    }

    private CustomizedButcherable getNeededTable(BlockPos position) {
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        ButcherBlockContext context = new ButcherBlockContext((LevelReader)this.world, position, this.world.getBlockState(position));
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            CustomizedButcherable butcherable = this.selectByItem(item);
            if (butcherable == null || butcherable.isTableBlock(context)) continue;
            return butcherable;
        }
        return null;
    }

    @Nullable
    private ButcherInfo getButcherTable(BlockPos position) {
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        ButcherBlockContext context = new ButcherBlockContext((LevelReader)this.world, position, this.world.getBlockState(position));
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            CustomizedButcherable butcherable = this.selectByItem(item);
            if (butcherable == null || !butcherable.isTableBlock(context)) continue;
            return new ButcherInfo(butcherable, false, i);
        }
        return null;
    }

    @Nullable
    private ButcherInfo getButcherInfo(BlockPos pos) {
        ButcherInfo butcheringBlock = this.getButcheringBlock(pos);
        if (butcheringBlock != null) {
            return butcheringBlock;
        }
        return this.getButcherTable(pos);
    }

    private IAIState butcher() {
        ButcherCitizenContext citizenContext;
        ServerLevel level = this.world;
        AbstractEntityCitizen worker = this.worker;
        BlockPos position = this.butcherPosition;
        if (position == null) {
            return AIWorkerState.START_WORKING;
        }
        ButcherInfo info = this.getButcherInfo(position);
        if (info == null) {
            return AIWorkerState.START_WORKING;
        }
        ButcherBlockContext blockContext = new ButcherBlockContext((LevelReader)level, position, level.getBlockState(position));
        ToolOrIngredientStack toolType = info.getTool(blockContext, citizenContext = new ButcherCitizenContext(this, worker));
        if (this.equipTool(toolType)) {
            return AIWorkerState.START_WORKING;
        }
        if (!EntityNavigationUtils.walkToPosInBuilding((AbstractFastMinecoloniesEntity)worker, (BlockPos)position, (IBuilding)this.building, (int)(this.walking ? EntityNavigationUtils.WOKR_IN_BUILDING_DIST : 0))) {
            this.walking = true;
            return this.getState();
        }
        InteractionHand itemHand = !toolType.isEmpty() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        CitizenItemUtils.setHeldItem((AbstractEntityCitizen)worker, (InteractionHand)itemHand, (int)info.slot());
        ButcherConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.butcher;
        int delay = (Integer)config.workDelay.get() - (int)((double)(this.getPrimarySkillLevel() + this.getSecondarySkillLevel()) * (Double)config.workDelayReducePerSkillLevel.get());
        this.hitBlockWithToolInHand(position);
        worker.queueSound(info.getSound(blockContext), position, 1, 0);
        if (this.butcherProgress < delay) {
            this.butcherProgress += 5;
            return this.getState();
        }
        this.butcherProgress = 0;
        info.doButcher(blockContext, citizenContext, itemHand);
        CitizenItemUtils.setHeldItem((AbstractEntityCitizen)worker, (InteractionHand)itemHand, (int)info.slot());
        worker.getCitizenExperienceHandler().addExperience(0.5);
        if (this.getButcheringBlock(position) != null) {
            this.setDelay(10);
            worker.decreaseSaturationForContinuousAction();
            return this.getState();
        }
        this.setDelay(20);
        this.incrementActionsDoneAndDecSaturation();
        if (((JobButcher)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.getButcherTable(position) != null) {
            return this.getState();
        }
        return AIWorkerState.START_WORKING;
    }

    private boolean equipTool(ToolOrIngredientStack toolType) {
        int slot = -1;
        if (toolType.isEmpty()) {
            slot = -1;
        } else if (toolType.isToolType()) {
            if (this.checkForToolOrWeapon(toolType.toolType())) {
                return true;
            }
            slot = CitizenHelper.getMaxLevelToolSlot(this.worker.getCitizenData(), toolType.toolType());
        } else {
            IngredientStack stack = toolType.stack();
            if (!this.checkIfRequestForItemExistOrCreate(stack, CustomToolType.getFallbackTranslationKey((ResourceLocation)ModToolTypes.BUTCHER_TOOL.getName()))) {
                return true;
            }
            slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), stack::testType);
        }
        CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.worker, (InteractionHand)InteractionHand.MAIN_HAND, (int)slot);
        return false;
    }

    private boolean checkIfRequestForItemExistOrCreate(IngredientStack stack, String description) {
        AbstractEntityCitizen worker = this.worker;
        AbstractBuilding building = this.building;
        int invCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)worker.getInventoryCitizen(), stack::testType);
        if (invCount >= stack.count()) {
            return true;
        }
        if (!this.walkToBuilding()) {
            return false;
        }
        int updatedCount = stack.count() - invCount;
        if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)building, stack::testType, (int)updatedCount) >= updatedCount) {
            if (InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler((IItemHandlerCapProvider)building, stack::testType, (int)updatedCount, (IItemHandler)worker.getInventoryCitizen())) {
                return true;
            }
        }
        IngredientDeliverable deliverable = new IngredientDeliverable(stack.ingredient(), description, stack.count());
        if (!CitizenHelper.isRequested(worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> this.testDeliverable((IDeliverable)r.getRequest(), deliverable))) {
            worker.getCitizenData().createRequest((IRequestable)new CustomizableDeliverable((IDeliverableObject)deliverable));
        }
        return false;
    }

    private boolean testDeliverable(IDeliverable deliverable, IngredientDeliverable deliverable2) {
        CustomizableDeliverable customizable;
        IDeliverableObject iDeliverableObject;
        if (deliverable instanceof CustomizableDeliverable && (iDeliverableObject = (customizable = (CustomizableDeliverable)deliverable).getObject()) instanceof IngredientDeliverable) {
            IngredientDeliverable other = (IngredientDeliverable)iDeliverableObject;
            return other.getIngredient().getStackingIds().equals((Object)deliverable2.getIngredient().getStackingIds());
        }
        return false;
    }

    private void hitBlockWithToolInHand(BlockPos pos) {
        AbstractEntityCitizen worker = this.worker;
        worker.getLookControl().setLookAt((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0f, (float)worker.getMaxHeadXRot());
        worker.swing(InteractionHand.MAIN_HAND);
        BlockState blockState = worker.level().getBlockState(pos);
        BlockPos vector = pos.subtract((Vec3i)worker.blockPosition());
        Direction facing = BlockPosUtil.directionFromDelta((int)vector.getX(), (int)vector.getY(), (int)vector.getZ()).getOpposite();
        Level level = worker.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new BlockParticleEffectMessage(pos, blockState, facing.ordinal()).sendToTargetPoint(serverLevel, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 16.0);
        }
    }

    static {
        InteractionValidatorRegistry.registerStandardPredicate((Component)TABLE_NEEDED_KEY, c -> {
            JobButcher job;
            IJob patt0$temp = c.getJob();
            return patt0$temp instanceof JobButcher && (job = (JobButcher)patt0$temp).getTableNeeded() != null;
        });
    }

    private record ButcherInfo(CustomizedButcherable butcherable, boolean isBlock, int slot) {
        public ToolOrIngredientStack getTool(ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
            if (this.isBlock()) {
                return this.butcherable().getBlockTool(context, citizen);
            }
            return this.butcherable().getTableTool(context, citizen);
        }

        public SoundEvent getSound(ButcherBlockContext context) {
            if (this.isBlock()) {
                return this.butcherable().getBlockSound(context);
            }
            return this.butcherable().getTableSound(context);
        }

        public void doButcher(ButcherBlockContext context, ButcherCitizenContext citizen, InteractionHand toolHand) {
            if (this.isBlock()) {
                this.butcherable().doButcherBlock(context, citizen);
            } else {
                this.butcherable().doButcherTable(context, citizen, toolHand);
            }
        }
    }
}

