/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai.butcher;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedButcherable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.building.module.ButcherableListModule;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class Butcherable
implements IDeliverableObject {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("butcherable");
    public static final Component SHORT_DISPLAY_STRING = Component.translatable((String)MineColoniesCompatibility.tl("butcherable"));
    public static final Component LONG_DISPLAY_STRING = Component.translatable((String)MineColoniesCompatibility.tl("butcherable.desc"));
    private static List<ItemStack> EXAMPLES = null;
    private final int minCount;
    private final ButcherableListModule blacklist;

    public Butcherable(int minCount, ButcherableListModule blacklist) {
        this.minCount = minCount;
        this.blacklist = blacklist;
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    public static Butcherable deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        int minCount = tag.getInt("minCount");
        return new Butcherable(minCount, null);
    }

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag, Butcherable request) {
        tag.putInt("minCount", request.minCount);
    }

    @NotNull
    public Component getShortDisplayString() {
        return SHORT_DISPLAY_STRING;
    }

    @NotNull
    public Component getLongDisplayString() {
        return LONG_DISPLAY_STRING;
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        if (EXAMPLES == null) {
            EXAMPLES = MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager().getListOfAllItems().stream().filter(this::matches).toList();
        }
        return EXAMPLES;
    }

    public static void reload() {
        EXAMPLES = null;
    }

    public Butcherable copyWithCount(int newCount) {
        return new Butcherable(this.minCount, this.blacklist);
    }

    public int getCount() {
        return 8;
    }

    public int getMinimumCount() {
        return this.minCount;
    }

    public ButcherableListModule getBlacklist() {
        return this.blacklist;
    }

    public boolean matches(@NotNull ItemStack stack) {
        CustomizedButcherable butcherable = CustomizedButcherable.selectByItem(stack);
        return butcherable != null && (this.blacklist == null || !this.blacklist.containsId(butcherable.getId()));
    }
}

