/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class StonecutterRecipeStorage
implements ICustomizedRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("stonecutting");
    public static final String TAG_RECIPE_ID = "recipeId";
    public static final String TAG_INGREDIENT = "ingredient";
    public static final String TAG_RESULT = "result";
    private final ResourceLocation recipeId;
    private final ItemStorage ingredient;
    private final ItemStack result;
    private final List<ItemStorage> input;

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag, StonecutterRecipeStorage recipe) {
        tag.putString(TAG_RECIPE_ID, recipe.recipeId.toString());
        tag.put(TAG_INGREDIENT, (Tag)controller.serializeTag(provider, (Object)recipe.ingredient));
        tag.put(TAG_RESULT, (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)recipe.result));
    }

    public static StonecutterRecipeStorage deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        ResourceLocation recipeId = ResourceLocation.parse((String)tag.getString(TAG_RECIPE_ID));
        ItemStorage ingredient = (ItemStorage)controller.deserializeTag(provider, tag.getCompound(TAG_INGREDIENT));
        ItemStack result = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_RESULT));
        return new StonecutterRecipeStorage(recipeId, ingredient, result);
    }

    public StonecutterRecipeStorage(ResourceLocation recipeId, ItemStorage ingredient, ItemStack result) {
        this.recipeId = recipeId;
        this.ingredient = ingredient;
        this.result = result;
        this.input = Collections.singletonList(ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.ingredient, this.result.getItem());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StonecutterRecipeStorage) {
            StonecutterRecipeStorage other = (StonecutterRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.ingredient.equals((Object)other.ingredient) && ItemStackHelper.equals(this.result, other.result);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public ItemStorage getIngredient() {
        return this.ingredient;
    }

    public List<ItemStorage> getInput() {
        return this.input;
    }

    public int getGridSize() {
        return 1;
    }

    public ItemStack getPrimaryOutput() {
        return this.result;
    }

    public List<ItemStack> getAlternateOutputs() {
        return Collections.emptyList();
    }

    public List<ItemStack> getSecondaryOutputs() {
        return Collections.emptyList();
    }

    public Block getIntermediate() {
        return Blocks.AIR;
    }

    public ResourceLocation getRecipeSource() {
        return null;
    }

    public ResourceLocation getRecipeType() {
        return null;
    }

    public ResourceKey<LootTable> getLootTable() {
        return null;
    }

    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }
}

