/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class SmithingRecipeStorage
implements ICustomizedRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("smithing");
    public static final String TAG_RECIPE_ID = "recipeId";
    public static final String TAG_TAMPLATE = "template";
    public static final String TAG_BASE = "base";
    public static final String TAG_ADDITION = "addition";
    public static final String TAG_RESULT = "result";
    private final ResourceLocation recipeId;
    private final ItemStorage template;
    private final ItemStorage base;
    private final ItemStorage addition;
    private final ItemStack result;
    private final List<ItemStorage> input;
    private final List<ItemStack> secondaryOutputs;

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag, SmithingRecipeStorage recipe) {
        tag.putString(TAG_RECIPE_ID, recipe.recipeId.toString());
        tag.put(TAG_TAMPLATE, (Tag)controller.serializeTag(provider, (Object)recipe.template));
        tag.put(TAG_BASE, (Tag)controller.serializeTag(provider, (Object)recipe.base));
        tag.put(TAG_ADDITION, (Tag)controller.serializeTag(provider, (Object)recipe.addition));
        tag.put(TAG_RESULT, (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)recipe.result));
    }

    public static SmithingRecipeStorage deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        ResourceLocation recipeId = ResourceLocation.parse((String)tag.getString(TAG_RECIPE_ID));
        ItemStorage template = (ItemStorage)controller.deserializeTag(provider, tag.getCompound(TAG_TAMPLATE));
        ItemStorage base = (ItemStorage)controller.deserializeTag(provider, tag.getCompound(TAG_BASE));
        ItemStorage addition = (ItemStorage)controller.deserializeTag(provider, tag.getCompound(TAG_ADDITION));
        ItemStack result = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_RESULT));
        return new SmithingRecipeStorage(recipeId, template, base, addition, result);
    }

    public SmithingRecipeStorage(ResourceLocation recipeId, ItemStorage template, ItemStorage base, ItemStorage addition, ItemStack result) {
        this.recipeId = recipeId;
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
        this.input = Arrays.asList(template, base, addition);
        this.secondaryOutputs = Arrays.asList(new ItemStack[0]);
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.template, this.base, this.addition, this.result.getItem());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SmithingRecipeStorage) {
            SmithingRecipeStorage other = (SmithingRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.template.equals((Object)other.template) && this.base.equals((Object)other.base) && this.addition.equals((Object)other.addition) && ItemStackHelper.equals(this.result, other.result);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public ItemStorage getBase() {
        return this.base;
    }

    public ItemStorage getAddition() {
        return this.addition;
    }

    public List<ItemStorage> getInput() {
        return this.input;
    }

    public int getGridSize() {
        return 2;
    }

    public ItemStack getPrimaryOutput() {
        return this.result;
    }

    public List<ItemStack> getAlternateOutputs() {
        return Collections.emptyList();
    }

    public List<ItemStack> getSecondaryOutputs() {
        return this.secondaryOutputs;
    }

    public Block getIntermediate() {
        return Blocks.AIR;
    }

    public ResourceLocation getRecipeSource() {
        return null;
    }

    public ResourceLocation getRecipeType() {
        return null;
    }

    public ResourceKey<LootTable> getLootTable() {
        return null;
    }

    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }
}

